# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from .file_encoding import FileEncoding
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ScriptFileCreate(UniversalBaseModel):
    """
    Model representing a file in a script.
    """

    path: str = pydantic.Field()
    """
    File path relative to script root
    """

    content: str = pydantic.Field()
    """
    Base64 encoded file content
    """

    encoding: typing.Optional[FileEncoding] = pydantic.Field(default=None)
    """
    Content encoding
    """

    mime_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    MIME type (auto-detected if not provided)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
