# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
import datetime as dt
from .otp_type import OtpType
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class TotpCode(UniversalBaseModel):
    totp_identifier: str = pydantic.Field()
    """
    The identifier of the TOTP code. It can be the email address, phone number, or the identifier of the user.
    """

    task_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The task_id the totp code is for. It can be the task_id of the task that the TOTP code is for.
    """

    workflow_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The workflow ID the TOTP code is for. It can be the workflow ID of the workflow that the TOTP code is for.
    """

    workflow_run_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The workflow run id that the TOTP code is for. It can be the workflow run id of the workflow run that the TOTP code is for.
    """

    source: typing.Optional[str] = pydantic.Field(default=None)
    """
    An optional field. The source of the TOTP code. e.g. email, sms, etc.
    """

    content: str = pydantic.Field()
    """
    The content of the TOTP code. It can be the email content that contains the TOTP code, or the sms message that contains the TOTP code. Skyvern will automatically extract the TOTP code from the content.
    """

    expired_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp when the TOTP code expires
    """

    totp_code_id: str = pydantic.Field()
    """
    The skyvern ID of the TOTP code.
    """

    code: str = pydantic.Field()
    """
    The TOTP code extracted from the content.
    """

    organization_id: str = pydantic.Field()
    """
    The ID of the organization that the TOTP code is for.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The timestamp when the TOTP code was created.
    """

    modified_at: dt.datetime = pydantic.Field()
    """
    The timestamp when the TOTP code was modified.
    """

    otp_type: typing.Optional[OtpType] = pydantic.Field(default=None)
    """
    The type of the OTP code.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
