# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ..core.pydantic_utilities import UniversalBaseModel
import typing
from .run_engine import RunEngine
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic
from .extraction_block_yaml_data_schema import ExtractionBlockYamlDataSchema
from .file_storage_type import FileStorageType
import typing_extensions
from ..core.serialization import FieldMetadata
from .file_type import FileType
from .task_block_yaml_data_schema import TaskBlockYamlDataSchema
from ..core.pydantic_utilities import update_forward_refs


class WorkflowDefinitionYamlBlocksItem_Action(UniversalBaseModel):
    block_type: typing.Literal["action"] = "action"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    url: typing.Optional[str] = None
    title: typing.Optional[str] = None
    engine: typing.Optional[RunEngine] = None
    navigation_goal: typing.Optional[str] = None
    error_code_mapping: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None
    max_retries: typing.Optional[int] = None
    parameter_keys: typing.Optional[typing.List[str]] = None
    complete_on_download: typing.Optional[bool] = None
    download_suffix: typing.Optional[str] = None
    totp_verification_url: typing.Optional[str] = None
    totp_identifier: typing.Optional[str] = None
    cache_actions: typing.Optional[bool] = None
    disable_cache: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_Code(UniversalBaseModel):
    block_type: typing.Literal["code"] = "code"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    code: str
    parameter_keys: typing.Optional[typing.List[str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_DownloadToS3(UniversalBaseModel):
    block_type: typing.Literal["download_to_s3"] = "download_to_s3"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_Extraction(UniversalBaseModel):
    block_type: typing.Literal["extraction"] = "extraction"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    data_extraction_goal: str
    url: typing.Optional[str] = None
    title: typing.Optional[str] = None
    engine: typing.Optional[RunEngine] = None
    data_schema: typing.Optional[ExtractionBlockYamlDataSchema] = None
    max_retries: typing.Optional[int] = None
    max_steps_per_run: typing.Optional[int] = None
    parameter_keys: typing.Optional[typing.List[str]] = None
    cache_actions: typing.Optional[bool] = None
    disable_cache: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_FileDownload(UniversalBaseModel):
    block_type: typing.Literal["file_download"] = "file_download"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    navigation_goal: str
    url: typing.Optional[str] = None
    title: typing.Optional[str] = None
    engine: typing.Optional[RunEngine] = None
    error_code_mapping: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None
    max_retries: typing.Optional[int] = None
    max_steps_per_run: typing.Optional[int] = None
    parameter_keys: typing.Optional[typing.List[str]] = None
    download_suffix: typing.Optional[str] = None
    totp_verification_url: typing.Optional[str] = None
    totp_identifier: typing.Optional[str] = None
    cache_actions: typing.Optional[bool] = None
    disable_cache: typing.Optional[bool] = None
    download_timeout: typing.Optional[float] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_FileUpload(UniversalBaseModel):
    block_type: typing.Literal["file_upload"] = "file_upload"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    storage_type: typing.Optional[FileStorageType] = None
    s3bucket: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="s3_bucket")] = None
    aws_access_key_id: typing.Optional[str] = None
    aws_secret_access_key: typing.Optional[str] = None
    region_name: typing.Optional[str] = None
    azure_storage_account_name: typing.Optional[str] = None
    azure_storage_account_key: typing.Optional[str] = None
    azure_blob_container_name: typing.Optional[str] = None
    azure_folder_path: typing.Optional[str] = None
    path: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_FileUrlParser(UniversalBaseModel):
    block_type: typing.Literal["file_url_parser"] = "file_url_parser"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    file_url: str
    file_type: FileType
    json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_ForLoop(UniversalBaseModel):
    block_type: typing.Literal["for_loop"] = "for_loop"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    loop_blocks: typing.List["ForLoopBlockYamlLoopBlocksItem"]
    loop_over_parameter_key: typing.Optional[str] = None
    loop_variable_reference: typing.Optional[str] = None
    complete_if_empty: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .for_loop_block_yaml import ForLoopBlockYaml  # noqa: E402
from .for_loop_block_yaml_loop_blocks_item import ForLoopBlockYamlLoopBlocksItem  # noqa: E402


class WorkflowDefinitionYamlBlocksItem_GotoUrl(UniversalBaseModel):
    block_type: typing.Literal["goto_url"] = "goto_url"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    url: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_HttpRequest(UniversalBaseModel):
    block_type: typing.Literal["http_request"] = "http_request"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    method: typing.Optional[str] = None
    url: typing.Optional[str] = None
    headers: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None
    body: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    timeout: typing.Optional[int] = None
    follow_redirects: typing.Optional[bool] = None
    parameter_keys: typing.Optional[typing.List[str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_Login(UniversalBaseModel):
    block_type: typing.Literal["login"] = "login"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    url: typing.Optional[str] = None
    title: typing.Optional[str] = None
    engine: typing.Optional[RunEngine] = None
    navigation_goal: typing.Optional[str] = None
    error_code_mapping: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None
    max_retries: typing.Optional[int] = None
    max_steps_per_run: typing.Optional[int] = None
    parameter_keys: typing.Optional[typing.List[str]] = None
    totp_verification_url: typing.Optional[str] = None
    totp_identifier: typing.Optional[str] = None
    cache_actions: typing.Optional[bool] = None
    disable_cache: typing.Optional[bool] = None
    complete_criterion: typing.Optional[str] = None
    terminate_criterion: typing.Optional[str] = None
    complete_verification: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_Navigation(UniversalBaseModel):
    block_type: typing.Literal["navigation"] = "navigation"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    navigation_goal: str
    url: typing.Optional[str] = None
    title: typing.Optional[str] = None
    engine: typing.Optional[RunEngine] = None
    error_code_mapping: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None
    max_retries: typing.Optional[int] = None
    max_steps_per_run: typing.Optional[int] = None
    parameter_keys: typing.Optional[typing.List[str]] = None
    complete_on_download: typing.Optional[bool] = None
    download_suffix: typing.Optional[str] = None
    totp_verification_url: typing.Optional[str] = None
    totp_identifier: typing.Optional[str] = None
    cache_actions: typing.Optional[bool] = None
    disable_cache: typing.Optional[bool] = None
    complete_criterion: typing.Optional[str] = None
    terminate_criterion: typing.Optional[str] = None
    complete_verification: typing.Optional[bool] = None
    include_action_history_in_verification: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_PdfParser(UniversalBaseModel):
    block_type: typing.Literal["pdf_parser"] = "pdf_parser"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    file_url: str
    json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_SendEmail(UniversalBaseModel):
    block_type: typing.Literal["send_email"] = "send_email"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    smtp_host_secret_parameter_key: str
    smtp_port_secret_parameter_key: str
    smtp_username_secret_parameter_key: str
    smtp_password_secret_parameter_key: str
    sender: str
    recipients: typing.List[str]
    subject: str
    body: str
    file_attachments: typing.Optional[typing.List[str]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_Task(UniversalBaseModel):
    block_type: typing.Literal["task"] = "task"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    url: typing.Optional[str] = None
    title: typing.Optional[str] = None
    engine: typing.Optional[RunEngine] = None
    navigation_goal: typing.Optional[str] = None
    data_extraction_goal: typing.Optional[str] = None
    data_schema: typing.Optional[TaskBlockYamlDataSchema] = None
    error_code_mapping: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None
    max_retries: typing.Optional[int] = None
    max_steps_per_run: typing.Optional[int] = None
    parameter_keys: typing.Optional[typing.List[str]] = None
    complete_on_download: typing.Optional[bool] = None
    download_suffix: typing.Optional[str] = None
    totp_verification_url: typing.Optional[str] = None
    totp_identifier: typing.Optional[str] = None
    cache_actions: typing.Optional[bool] = None
    disable_cache: typing.Optional[bool] = None
    complete_criterion: typing.Optional[str] = None
    terminate_criterion: typing.Optional[str] = None
    complete_verification: typing.Optional[bool] = None
    include_action_history_in_verification: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_TaskV2(UniversalBaseModel):
    block_type: typing.Literal["task_v2"] = "task_v2"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    prompt: str
    url: typing.Optional[str] = None
    totp_verification_url: typing.Optional[str] = None
    totp_identifier: typing.Optional[str] = None
    max_iterations: typing.Optional[int] = None
    max_steps: typing.Optional[int] = None
    disable_cache: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_TextPrompt(UniversalBaseModel):
    block_type: typing.Literal["text_prompt"] = "text_prompt"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    llm_key: typing.Optional[str] = None
    prompt: str
    parameter_keys: typing.Optional[typing.List[str]] = None
    json_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_UploadToS3(UniversalBaseModel):
    block_type: typing.Literal["upload_to_s3"] = "upload_to_s3"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    path: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_Validation(UniversalBaseModel):
    block_type: typing.Literal["validation"] = "validation"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    complete_criterion: typing.Optional[str] = None
    terminate_criterion: typing.Optional[str] = None
    error_code_mapping: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None
    parameter_keys: typing.Optional[typing.List[str]] = None
    disable_cache: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class WorkflowDefinitionYamlBlocksItem_Wait(UniversalBaseModel):
    block_type: typing.Literal["wait"] = "wait"
    label: str
    continue_on_failure: typing.Optional[bool] = None
    model: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    wait_sec: typing.Optional[int] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


WorkflowDefinitionYamlBlocksItem = typing.Union[
    WorkflowDefinitionYamlBlocksItem_Action,
    WorkflowDefinitionYamlBlocksItem_Code,
    WorkflowDefinitionYamlBlocksItem_DownloadToS3,
    WorkflowDefinitionYamlBlocksItem_Extraction,
    WorkflowDefinitionYamlBlocksItem_FileDownload,
    WorkflowDefinitionYamlBlocksItem_FileUpload,
    WorkflowDefinitionYamlBlocksItem_FileUrlParser,
    WorkflowDefinitionYamlBlocksItem_ForLoop,
    WorkflowDefinitionYamlBlocksItem_GotoUrl,
    WorkflowDefinitionYamlBlocksItem_HttpRequest,
    WorkflowDefinitionYamlBlocksItem_Login,
    WorkflowDefinitionYamlBlocksItem_Navigation,
    WorkflowDefinitionYamlBlocksItem_PdfParser,
    WorkflowDefinitionYamlBlocksItem_SendEmail,
    WorkflowDefinitionYamlBlocksItem_Task,
    WorkflowDefinitionYamlBlocksItem_TaskV2,
    WorkflowDefinitionYamlBlocksItem_TextPrompt,
    WorkflowDefinitionYamlBlocksItem_UploadToS3,
    WorkflowDefinitionYamlBlocksItem_Validation,
    WorkflowDefinitionYamlBlocksItem_Wait,
]
update_forward_refs(WorkflowDefinitionYamlBlocksItem_ForLoop)
