# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
import typing
from .proxy_location import ProxyLocation
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class WorkflowRunRequest(UniversalBaseModel):
    workflow_id: str = pydantic.Field()
    """
    ID of the workflow to run. Workflow ID starts with `wpid_`.
    """

    parameters: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Parameters to pass to the workflow
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title for this workflow run
    """

    proxy_location: typing.Optional[ProxyLocation] = pydantic.Field(default=None)
    """
    
    Geographic Proxy location to route the browser traffic through. This is only available in Skyvern Cloud.
    
    Available geotargeting options:
    - RESIDENTIAL: the default value. Skyvern Cloud uses a random US residential proxy.
    - RESIDENTIAL_ES: Spain
    - RESIDENTIAL_IE: Ireland
    - RESIDENTIAL_GB: United Kingdom
    - RESIDENTIAL_IN: India
    - RESIDENTIAL_JP: Japan
    - RESIDENTIAL_FR: France
    - RESIDENTIAL_DE: Germany
    - RESIDENTIAL_NZ: New Zealand
    - RESIDENTIAL_ZA: South Africa
    - RESIDENTIAL_AR: Argentina
    - RESIDENTIAL_AU: Australia
    - RESIDENTIAL_ISP: ISP proxy
    - US-CA: California
    - US-NY: New York
    - US-TX: Texas
    - US-FL: Florida
    - US-WA: Washington
    - NONE: No proxy
    """

    webhook_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL to send workflow status updates to after a run is finished. Refer to https://www.skyvern.com/docs/running-tasks/webhooks-faq for webhook questions.
    """

    totp_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    
    URL that serves TOTP/2FA/MFA codes for Skyvern to use during the workflow run. Refer to https://www.skyvern.com/docs/credentials/totp#option-2-get-code-from-your-endpoint for more details.
    """

    totp_identifier: typing.Optional[str] = pydantic.Field(default=None)
    """
    
    Identifier for the TOTP/2FA/MFA code when the code is pushed to Skyvern. Refer to https://www.skyvern.com/docs/credentials/totp#option-3-push-code-to-skyvern for more details.
    """

    browser_session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of a Skyvern browser session to reuse, having it continue from the current screen state
    """

    max_screenshot_scrolls: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum number of scrolls for the post action screenshot. When it's None or 0, it takes the current viewpoint screenshot.
    """

    extra_http_headers: typing.Optional[typing.Dict[str, typing.Optional[str]]] = pydantic.Field(default=None)
    """
    The extra HTTP headers for the requests in browser.
    """

    browser_address: typing.Optional[str] = pydantic.Field(default=None)
    """
    The CDP address for the workflow run.
    """

    ai_fallback: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to fallback to AI if the workflow run fails.
    """

    run_with: typing.Optional[str] = pydantic.Field(default=None)
    """
    Whether to run the workflow with agent or code.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
