# This file was auto-generated by Fern from our API Definition.

from ..core.pydantic_utilities import UniversalBaseModel
import pydantic
from .run_status import RunStatus
import typing
from .workflow_run_response_output import WorkflowRunResponseOutput
from .file_info import FileInfo
import datetime as dt
from .script_run_response import ScriptRunResponse
from .workflow_run_request import WorkflowRunRequest
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class WorkflowRunResponse(UniversalBaseModel):
    run_id: str = pydantic.Field()
    """
    Unique identifier for this run. Run ID starts with `tsk_` for task runs and `wr_` for workflow runs.
    """

    status: RunStatus = pydantic.Field()
    """
    Current status of the run
    """

    output: typing.Optional[WorkflowRunResponseOutput] = pydantic.Field(default=None)
    """
    Output data from the run, if any. Format/schema depends on the data extracted by the run.
    """

    downloaded_files: typing.Optional[typing.List[FileInfo]] = pydantic.Field(default=None)
    """
    List of files downloaded during the run
    """

    recording_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL to the recording of the run
    """

    screenshot_urls: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of last n screenshot URLs in reverse chronological order - the first one the list is the latest screenshot.
    """

    failure_reason: typing.Optional[str] = pydantic.Field(default=None)
    """
    Reason for failure if the run failed or terminated
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Timestamp when this run was created
    """

    modified_at: dt.datetime = pydantic.Field()
    """
    Timestamp when this run was last modified
    """

    queued_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when this run was queued
    """

    started_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when this run started execution
    """

    finished_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when this run finished
    """

    app_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL to the application UI where the run can be viewed
    """

    browser_session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the Skyvern persistent browser session used for this run
    """

    max_screenshot_scrolls: typing.Optional[int] = pydantic.Field(default=None)
    """
    The maximum number of scrolls for the post action screenshot. When it's None or 0, it takes the current viewpoint screenshot
    """

    script_run: typing.Optional[ScriptRunResponse] = pydantic.Field(default=None)
    """
    The script run result
    """

    errors: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(default=None)
    """
    The errors for the run
    """

    run_with: typing.Optional[str] = pydantic.Field(default=None)
    """
    Whether the workflow run was executed with agent or code
    """

    ai_fallback: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to fallback to AI if code run fails.
    """

    run_request: typing.Optional[WorkflowRunRequest] = pydantic.Field(default=None)
    """
    The original request parameters used to start this workflow run
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
