# Theory Library Documentation Hub

[← Back to Theory Library](../README.md) | [API Documentation →](../../../README.md) | [Development Guide →](../../../../docs/DEVELOPMENT.md)

## Directory Structure
```
theory_lib/docs/
├── README.md               # This file - documentation navigation guide
├── USAGE_GUIDE.md          # Practical usage patterns and examples
├── CONTRIBUTING.md         # Theory implementation and contribution guide
├── THEORY_ARCHITECTURE.md  # Architecture patterns and design principles
├── EXAMPLES.md             # Cross-theory examples and comparisons
└── UNIT_TESTS.md           # Testing methodology and framework usage
```

## Overview

The **Theory Library Documentation** provides comprehensive guides for using, understanding, and extending the ModelChecker's semantic theory collection. This documentation serves different audiences from researchers exploring semantic theories to developers implementing new theoretical frameworks.

The documentation covers **practical usage patterns**, **architectural design principles**, **implementation guidelines**, and **testing methodologies** to ensure effective use and development of semantic theories within the ModelChecker ecosystem.

This resource collection supports the theory library's role as a **computational platform for logic research**, enabling systematic comparison between semantic approaches and facilitating the implementation of new theoretical frameworks.


## Subdirectories

This documentation hub organizes theory library resources for different development and research activities, providing targeted guidance for specific tasks and user types.

## Documentation

### For New Users
- **[Usage Guide](USAGE_GUIDE.md)** - Import strategies, basic examples, and theory configuration patterns
- **[Cross-Theory Examples](EXAMPLES.md)** - Comparative analysis and formula testing across theories
- **[Individual Theory Documentation](../logos/README.md)** - Theory-specific guides and implementations

### For Researchers
- **[Architecture Guide](THEORY_ARCHITECTURE.md)** - Simple vs Modular patterns and theoretical design principles
- **[Comparative Analysis](EXAMPLES.md)** - Cross-theory behavior and semantic differences
- **[Academic Integration](CONTRIBUTING.md#licensing-and-attribution)** - Citation and attribution practices

### For Developers
- **[Contributing Guide](CONTRIBUTING.md)** - Complete theory implementation workflow and requirements
- **[Testing Framework](UNIT_TESTS.md)** - Comprehensive testing patterns for theory validation
- **[Architecture Patterns](THEORY_ARCHITECTURE.md)** - Design principles and implementation strategies

## References

### Implementation Documentation
- Theory library documentation follows modular organization with audience-specific resources
- Cross-references maintained with individual theory documentation and framework guides

### Related Resources
- **[Theory Library Overview](../README.md)** - Main library documentation and theory collection
- **[ModelChecker Framework](../../../README.md)** - Core API and system architecture
- **[Development Documentation](../../../../docs/README.md)** - Framework development and contribution procedures

---

[← Back to Theory Library](../README.md) | [API Documentation →](../../../README.md) | [Development Guide →](../../../../docs/DEVELOPMENT.md)
