# Constitutive Subtheory Citation

## Software Implementation Citation

If you use the constitutive subtheory implementation in your research, please cite:

```bibtex
@software{logos_constitutive_implementation,
  author = {Benjamin Brast-McKie},
  title = {Logos Constitutive Subtheory: Hyperintensional Content Relations Implementation},
  year = {2024},
  url = {https://github.com/benbrastmckie/ModelChecker},
  version = {1.0.0}
}
```

## Semantic Theory Citation

The constitutive operators implemented in this subtheory are based on the hyperintensional semantics developed in:

```bibtex
@article{brast_mckie_identity_aboutness,
  author = {Benjamin Brast-McKie},
  title = {Identity and Aboutness},
  journal = {Journal of Philosophical Logic},
  volume = {50},
  pages = {1471--1503},
  year = {2021},
  doi = {10.1007/s10992-021-09612-w}
}
```

## Related Foundational Work

The truthmaker semantics framework underlying this implementation:

```bibtex
@article{fine_truthmaker_content_i,
  author = {Kit Fine},
  title = {A Theory of Truthmaker Content I: Conjunction, Disjunction and Negation},
  journal = {Journal of Philosophical Logic},
  volume = {46},
  number = {6},
  pages = {625--674},
  year = {2017},
  doi = {10.1007/s10992-016-9413-y}
}
```

```bibtex
@article{fine_truthmaker_content_ii,
  author = {Kit Fine},
  title = {A Theory of Truthmaker Content II: Subject-matter, Common Content, Remainder and Ground},
  journal = {Journal of Philosophical Logic},
  volume = {46},
  number = {6},
  pages = {675--702},
  year = {2017},
  doi = {10.1007/s10992-016-9419-5}
}
```

## Description

This subtheory implements hyperintensional operators for content relationships including identity (≡), ground (≤), essence (⊑), relevance (⪯), and reduction (⟹). These operators enable fine-grained analysis of propositional content that goes beyond extensional and intensional equivalence.