"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from squadcast_sdk.errors import SquadcastSDKError
from squadcast_sdk.models import (
    common_v3_errormeta as models_common_v3_errormeta,
    v3_incidents_incidentactions_circlecierrormeta as models_v3_incidents_incidentactions_circlecierrormeta,
)
from squadcast_sdk.types import BaseModel
from typing import Optional, Union
from typing_extensions import TypeAliasType


class GatewayTimeoutErrorData(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class GatewayTimeoutError(SquadcastSDKError):
    r"""Server error"""

    data: GatewayTimeoutErrorData = field(hash=False)

    def __init__(
        self,
        data: GatewayTimeoutErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class ServiceUnavailableErrorData(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class ServiceUnavailableError(SquadcastSDKError):
    r"""Service unavailable."""

    data: ServiceUnavailableErrorData = field(hash=False)

    def __init__(
        self,
        data: ServiceUnavailableErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class BadGatewayErrorData(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class BadGatewayError(SquadcastSDKError):
    r"""Server error"""

    data: BadGatewayErrorData = field(hash=False)

    def __init__(
        self,
        data: BadGatewayErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class InternalServerErrorData(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class InternalServerError(SquadcastSDKError):
    r"""Server error"""

    data: InternalServerErrorData = field(hash=False)

    def __init__(
        self,
        data: InternalServerErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class UnprocessableEntityErrorData(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class UnprocessableEntityError(SquadcastSDKError):
    r"""Client error"""

    data: UnprocessableEntityErrorData = field(hash=False)

    def __init__(
        self,
        data: UnprocessableEntityErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class ConflictErrorData(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class ConflictError(SquadcastSDKError):
    r"""The request conflicts with the current state of the server."""

    data: ConflictErrorData = field(hash=False)

    def __init__(
        self,
        data: ConflictErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class NotFoundErrorData(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class NotFoundError(SquadcastSDKError):
    r"""The server cannot find the requested resource."""

    data: NotFoundErrorData = field(hash=False)

    def __init__(
        self,
        data: NotFoundErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class ForbiddenErrorData(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class ForbiddenError(SquadcastSDKError):
    r"""Access is forbidden."""

    data: ForbiddenErrorData = field(hash=False)

    def __init__(
        self,
        data: ForbiddenErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class PaymentRequiredErrorData(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class PaymentRequiredError(SquadcastSDKError):
    r"""Client error"""

    data: PaymentRequiredErrorData = field(hash=False)

    def __init__(
        self,
        data: PaymentRequiredErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class UnauthorizedErrorData(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class UnauthorizedError(SquadcastSDKError):
    r"""Access is unauthorized."""

    data: UnauthorizedErrorData = field(hash=False)

    def __init__(
        self,
        data: UnauthorizedErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class BadRequestErrorData(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class BadRequestError(SquadcastSDKError):
    r"""The server could not understand the request due to invalid syntax."""

    data: BadRequestErrorData = field(hash=False)

    def __init__(
        self,
        data: BadRequestErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class ResponseBodyError2Data(BaseModel):
    meta: models_common_v3_errormeta.CommonV3ErrorMeta
    r"""Represents a single response containing data of type T."""


@dataclass(unsafe_hash=True)
class ResponseBodyError2(SquadcastSDKError):
    data: ResponseBodyError2Data = field(hash=False)

    def __init__(
        self,
        data: ResponseBodyError2Data,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


class ResponseBodyError1Data(BaseModel):
    meta: models_v3_incidents_incidentactions_circlecierrormeta.V3IncidentsIncidentActionsCircleCIErrorMeta
    r"""Represents the metadata for a CircleCI error response."""


@dataclass(unsafe_hash=True)
class ResponseBodyError1(SquadcastSDKError):
    data: ResponseBodyError1Data = field(hash=False)

    def __init__(
        self,
        data: ResponseBodyError1Data,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)


BadRequestUnion = TypeAliasType(
    "BadRequestUnion", Union[ResponseBodyError1Data, ResponseBodyError2Data]
)
r"""Represents a CircleCI error response for a 400 status code."""


@dataclass(unsafe_hash=True)
class BadRequest(SquadcastSDKError):
    r"""Represents a CircleCI error response for a 400 status code."""

    data: BadRequestUnion = field(hash=False)

    def __init__(
        self,
        data: BadRequestUnion,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
