"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from squadcast_sdk.errors import SquadcastSDKError
from squadcast_sdk.models import common_v4_error as models_common_v4_error
from squadcast_sdk.types import BaseModel
from typing import Optional


class CommonV4ErrorData(BaseModel):
    error: models_common_v4_error.Error


@dataclass(unsafe_hash=True)
class CommonV4Error(SquadcastSDKError):
    data: CommonV4ErrorData = field(hash=False)

    def __init__(
        self,
        data: CommonV4ErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
