"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .sdkconfiguration import SDKConfiguration
from jsonpath import JSONPath
from squadcast_sdk import errors, models, utils
from squadcast_sdk._hooks import HookContext
from squadcast_sdk.globaleventrules_rulesets import GlobalEventRulesRulesets
from squadcast_sdk.types import OptionalNullable, UNSET
from squadcast_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Dict, List, Mapping, Optional, Union


class GlobalEventRules(BaseSDK):
    rulesets: GlobalEventRulesRulesets

    def __init__(
        self, sdk_config: SDKConfiguration, parent_ref: Optional[object] = None
    ) -> None:
        BaseSDK.__init__(self, sdk_config, parent_ref=parent_ref)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self):
        self.rulesets = GlobalEventRulesRulesets(
            self.sdk_configuration, parent_ref=self.parent_ref
        )

    def list(
        self,
        *,
        owner_id: str,
        page_size: Optional[int] = None,
        page_number: Optional[int] = None,
        filters_owner_id: Optional[List[str]] = None,
        filters_search: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GlobalEventRulesListGlobalEventRulesResponse]:
        r"""List Global Event Rules

        Get a list of all GERs

        :param owner_id:
        :param page_size:
        :param page_number:
        :param filters_owner_id:
        :param filters_search:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GlobalEventRulesListGlobalEventRulesRequest(
            owner_id=owner_id,
            page_size=page_size,
            page_number=page_number,
            filters_owner_id=filters_owner_id,
            filters_search=filters_search,
        )

        req = self._build_request(
            method="GET",
            path="/v3/global-event-rules",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GlobalEventRules_listGlobalEventRules",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> (
            Optional[models.GlobalEventRulesListGlobalEventRulesResponse]
        ):
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            page = request.page_number if not request.page_number is None else 1
            next_page = page + 1

            if not http_res.text:
                return None
            results = JSONPath("$.data").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.page_size if not request.page_size is None else 0
            if len(results[0]) < limit:
                return None

            return self.list(
                owner_id=owner_id,
                page_size=page_size,
                page_number=next_page,
                filters_owner_id=filters_owner_id,
                filters_search=filters_search,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GlobalEventRulesListGlobalEventRulesResponse(
                result=unmarshal_json_response(
                    models.GlobalEventRulesListGlobalEventRulesResponseBody, http_res
                ),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        owner_id: str,
        page_size: Optional[int] = None,
        page_number: Optional[int] = None,
        filters_owner_id: Optional[List[str]] = None,
        filters_search: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.GlobalEventRulesListGlobalEventRulesResponse]:
        r"""List Global Event Rules

        Get a list of all GERs

        :param owner_id:
        :param page_size:
        :param page_number:
        :param filters_owner_id:
        :param filters_search:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GlobalEventRulesListGlobalEventRulesRequest(
            owner_id=owner_id,
            page_size=page_size,
            page_number=page_number,
            filters_owner_id=filters_owner_id,
            filters_search=filters_search,
        )

        req = self._build_request_async(
            method="GET",
            path="/v3/global-event-rules",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GlobalEventRules_listGlobalEventRules",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> (
            Optional[models.GlobalEventRulesListGlobalEventRulesResponse]
        ):
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            page = request.page_number if not request.page_number is None else 1
            next_page = page + 1

            if not http_res.text:
                return None
            results = JSONPath("$.data").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.page_size if not request.page_size is None else 0
            if len(results[0]) < limit:
                return None

            return self.list(
                owner_id=owner_id,
                page_size=page_size,
                page_number=next_page,
                filters_owner_id=filters_owner_id,
                filters_search=filters_search,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.GlobalEventRulesListGlobalEventRulesResponse(
                result=unmarshal_json_response(
                    models.GlobalEventRulesListGlobalEventRulesResponseBody, http_res
                ),
                next=next_func,
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def create_rule(
        self,
        *,
        name: str,
        description: str,
        owner_id: str,
        entity_owner: Union[
            models.V3GlobalEventRulesEntityOwner,
            models.V3GlobalEventRulesEntityOwnerTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3GlobalEventRulesCreatedGlobalEventRuleResponse:
        r"""Create Global Event Rule

        Create a GER

        :param name:
        :param description:
        :param owner_id:
        :param entity_owner:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3GlobalEventRulesCreateGlobalEventRuleRequest(
            name=name,
            description=description,
            owner_id=owner_id,
            entity_owner=utils.get_pydantic_model(
                entity_owner, models.V3GlobalEventRulesEntityOwner
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v3/global-event-rules",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.V3GlobalEventRulesCreateGlobalEventRuleRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GlobalEventRules_createGlobalEventRule",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(
                models.GlobalEventRulesCreateGlobalEventRuleResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def create_rule_async(
        self,
        *,
        name: str,
        description: str,
        owner_id: str,
        entity_owner: Union[
            models.V3GlobalEventRulesEntityOwner,
            models.V3GlobalEventRulesEntityOwnerTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3GlobalEventRulesCreatedGlobalEventRuleResponse:
        r"""Create Global Event Rule

        Create a GER

        :param name:
        :param description:
        :param owner_id:
        :param entity_owner:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3GlobalEventRulesCreateGlobalEventRuleRequest(
            name=name,
            description=description,
            owner_id=owner_id,
            entity_owner=utils.get_pydantic_model(
                entity_owner, models.V3GlobalEventRulesEntityOwner
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v3/global-event-rules",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.V3GlobalEventRulesCreateGlobalEventRuleRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GlobalEventRules_createGlobalEventRule",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(
                models.GlobalEventRulesCreateGlobalEventRuleResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def delete_by_id(
        self,
        *,
        ger_id: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> bytes:
        r"""Delete Global Event Rule by ID

        Delete a GER by its ID

        :param ger_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GlobalEventRulesDeleteGlobalEventRuleByIDRequest(
            ger_id=ger_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/v3/global-event-rules/{ger_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="*/*",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GlobalEventRules_deleteGlobalEventRuleById",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*/*"):
            http_res_bytes = utils.stream_to_bytes(http_res)
            return http_res_bytes
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def delete_by_id_async(
        self,
        *,
        ger_id: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> bytes:
        r"""Delete Global Event Rule by ID

        Delete a GER by its ID

        :param ger_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GlobalEventRulesDeleteGlobalEventRuleByIDRequest(
            ger_id=ger_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/v3/global-event-rules/{ger_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="*/*",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GlobalEventRules_deleteGlobalEventRuleById",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*/*"):
            http_res_bytes = await utils.stream_to_bytes_async(http_res)
            return http_res_bytes
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def get_by_id(
        self,
        *,
        ger_id: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3GlobalEventRulesGlobalEventRuleResponse:
        r"""Get Global Event Rule by ID

        Get a GER by its ID

        :param ger_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GlobalEventRulesGetGlobalEventRuleByIDRequest(
            ger_id=ger_id,
        )

        req = self._build_request(
            method="GET",
            path="/v3/global-event-rules/{ger_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GlobalEventRules_getGlobalEventRuleById",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GlobalEventRulesGetGlobalEventRuleByIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def get_by_id_async(
        self,
        *,
        ger_id: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3GlobalEventRulesGlobalEventRuleResponse:
        r"""Get Global Event Rule by ID

        Get a GER by its ID

        :param ger_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GlobalEventRulesGetGlobalEventRuleByIDRequest(
            ger_id=ger_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v3/global-event-rules/{ger_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GlobalEventRules_getGlobalEventRuleById",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GlobalEventRulesGetGlobalEventRuleByIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def update_by_id(
        self,
        *,
        ger_id: int,
        name: Optional[str] = None,
        description: Optional[str] = None,
        entity_owner: Optional[
            Union[
                models.V3GlobalEventRulesEntityOwnerUpdate,
                models.V3GlobalEventRulesEntityOwnerUpdateTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3GlobalEventRulesGlobalEventRuleResponse:
        r"""Update Global Event Rule by ID

        Update a GER by its ID

        :param ger_id:
        :param name:
        :param description:
        :param entity_owner:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GlobalEventRulesUpdateGlobalEventRuleByIDRequest(
            ger_id=ger_id,
            v3_global_event_rules_update_global_event_rule_request=models.V3GlobalEventRulesUpdateGlobalEventRuleRequest(
                name=name,
                description=description,
                entity_owner=utils.get_pydantic_model(
                    entity_owner, Optional[models.V3GlobalEventRulesEntityOwnerUpdate]
                ),
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/v3/global-event-rules/{ger_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v3_global_event_rules_update_global_event_rule_request,
                False,
                False,
                "json",
                models.V3GlobalEventRulesUpdateGlobalEventRuleRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GlobalEventRules_updateGlobalEventRuleById",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GlobalEventRulesUpdateGlobalEventRuleByIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def update_by_id_async(
        self,
        *,
        ger_id: int,
        name: Optional[str] = None,
        description: Optional[str] = None,
        entity_owner: Optional[
            Union[
                models.V3GlobalEventRulesEntityOwnerUpdate,
                models.V3GlobalEventRulesEntityOwnerUpdateTypedDict,
            ]
        ] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3GlobalEventRulesGlobalEventRuleResponse:
        r"""Update Global Event Rule by ID

        Update a GER by its ID

        :param ger_id:
        :param name:
        :param description:
        :param entity_owner:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GlobalEventRulesUpdateGlobalEventRuleByIDRequest(
            ger_id=ger_id,
            v3_global_event_rules_update_global_event_rule_request=models.V3GlobalEventRulesUpdateGlobalEventRuleRequest(
                name=name,
                description=description,
                entity_owner=utils.get_pydantic_model(
                    entity_owner, Optional[models.V3GlobalEventRulesEntityOwnerUpdate]
                ),
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/v3/global-event-rules/{ger_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v3_global_event_rules_update_global_event_rule_request,
                False,
                False,
                "json",
                models.V3GlobalEventRulesUpdateGlobalEventRuleRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="GlobalEventRules_updateGlobalEventRuleById",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.GlobalEventRulesUpdateGlobalEventRuleByIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)
