"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .sdkconfiguration import SDKConfiguration
from datetime import datetime
from squadcast_sdk import errors, models, utils
from squadcast_sdk._hooks import HookContext
from squadcast_sdk.autopausetransientalerts import AutoPauseTransientAlerts
from squadcast_sdk.communicationcard import CommunicationCard
from squadcast_sdk.events import Events
from squadcast_sdk.incidentactions import IncidentActions
from squadcast_sdk.incidents_actions import IncidentsActions
from squadcast_sdk.incidents_additionalresponders import IncidentsAdditionalResponders
from squadcast_sdk.incidents_communicationcards import IncidentsCommunicationCards
from squadcast_sdk.incidents_export import IncidentsExport
from squadcast_sdk.incidents_postmortems import IncidentsPostmortems
from squadcast_sdk.incidents_snoozenotifications import IncidentsSnoozeNotifications
from squadcast_sdk.incidents_tags import IncidentsTags
from squadcast_sdk.notes import Notes
from squadcast_sdk.types import OptionalNullable, UNSET
from squadcast_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional, Union


class Incidents(BaseSDK):
    communication_card: CommunicationCard
    export: IncidentsExport
    communication_cards: IncidentsCommunicationCards
    tags: IncidentsTags
    notes: Notes
    actions: IncidentsActions
    incident_actions: IncidentActions
    additional_responders: IncidentsAdditionalResponders
    events: Events
    auto_pause_transient_alerts: AutoPauseTransientAlerts
    postmortems: IncidentsPostmortems
    snooze_notifications: IncidentsSnoozeNotifications

    def __init__(
        self, sdk_config: SDKConfiguration, parent_ref: Optional[object] = None
    ) -> None:
        BaseSDK.__init__(self, sdk_config, parent_ref=parent_ref)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self):
        self.communication_card = CommunicationCard(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.export = IncidentsExport(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.communication_cards = IncidentsCommunicationCards(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.tags = IncidentsTags(self.sdk_configuration, parent_ref=self.parent_ref)
        self.notes = Notes(self.sdk_configuration, parent_ref=self.parent_ref)
        self.actions = IncidentsActions(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.incident_actions = IncidentActions(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.additional_responders = IncidentsAdditionalResponders(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.events = Events(self.sdk_configuration, parent_ref=self.parent_ref)
        self.auto_pause_transient_alerts = AutoPauseTransientAlerts(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.postmortems = IncidentsPostmortems(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.snooze_notifications = IncidentsSnoozeNotifications(
            self.sdk_configuration, parent_ref=self.parent_ref
        )

    def bulk_acknowledge(
        self,
        *,
        incident_ids: List[str],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Bulk Acknowledge Incidents

        - This endpoint is used to bulk acknowledge the incident by IDs.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_ids:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3IncidentsBulkIncidentIDsRequest(
            incident_ids=incident_ids,
        )

        req = self._build_request(
            method="POST",
            path="/v3/incidents/acknowledge",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.V3IncidentsBulkIncidentIDsRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_bulkAcknowledgeIncidents",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsBulkAcknowledgeIncidentsResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def bulk_acknowledge_async(
        self,
        *,
        incident_ids: List[str],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Bulk Acknowledge Incidents

        - This endpoint is used to bulk acknowledge the incident by IDs.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_ids:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3IncidentsBulkIncidentIDsRequest(
            incident_ids=incident_ids,
        )

        req = self._build_request_async(
            method="POST",
            path="/v3/incidents/acknowledge",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.V3IncidentsBulkIncidentIDsRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_bulkAcknowledgeIncidents",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsBulkAcknowledgeIncidentsResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def export_incidents(
        self,
        *,
        start_time: datetime,
        end_time: datetime,
        type_: models.V3IncidentsExportFormat,
        owner_id: str,
        status: Optional[List[str]] = None,
        services: Optional[List[str]] = None,
        sources: Optional[List[str]] = None,
        assigned_to: Optional[List[str]] = None,
        assigned_to_user_i_ds_and_their_squads: Optional[List[str]] = None,
        service_owner: Optional[str] = None,
        priority: Optional[List[models.V3IncidentsIncidentPriority]] = None,
        tags: Optional[List[str]] = None,
        slo_affecting: Optional[
            models.V3IncidentsIncidentExportRequestSloAffecting
        ] = None,
        slos: Optional[List[int]] = None,
        is_starred: Optional[models.V3IncidentsIncidentExportRequestIsStarred] = None,
        text_filter: Optional[str] = None,
        notes: Optional[models.V3IncidentsIncidentExportRequestNotes] = None,
        retrospectives: Optional[
            models.V3IncidentsIncidentExportRequestRetrospectives
        ] = None,
        sort_by: Optional[models.V3IncidentsIncidentExportRequestSortBy] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Incident Export

        - This endpoint is used to export the incident details into a `csv` or `json` file.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.
        - Header field/value: `Content-Type`: `text/csv`


        Query Params:

        ```
        type: csv or json
        start_time: filter by date range
        end_time: filter by date range
        services: filter by services
        sources: filter by alert sources
        assigned_to: filter by assignee
        status: filter by incident status
        slo_affecting: filetr by slo affected
        slos: filter by slos
        tags: filter by tags key=value

        ```

        :param start_time:
        :param end_time:
        :param type: Defines the format of the export.
        :param owner_id:
        :param status:
        :param services:
        :param sources:
        :param assigned_to:
        :param assigned_to_user_i_ds_and_their_squads:
        :param service_owner:
        :param priority:
        :param tags:
        :param slo_affecting:
        :param slos:
        :param is_starred:
        :param text_filter:
        :param notes:
        :param retrospectives:
        :param sort_by:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsIncidentExportRequest(
            start_time=start_time,
            end_time=end_time,
            type=type_,
            owner_id=owner_id,
            status=status,
            services=services,
            sources=sources,
            assigned_to=assigned_to,
            assigned_to_user_i_ds_and_their_squads=assigned_to_user_i_ds_and_their_squads,
            service_owner=service_owner,
            priority=priority,
            tags=tags,
            slo_affecting=slo_affecting,
            slos=slos,
            is_starred=is_starred,
            text_filter=text_filter,
            notes=notes,
            retrospectives=retrospectives,
            sort_by=sort_by,
        )

        req = self._build_request(
            method="GET",
            path="/v3/incidents/export",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_incidentExport",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "2XX", "*"):
            return
        if utils.match_response(http_res, ["400", "401", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def export_incidents_async(
        self,
        *,
        start_time: datetime,
        end_time: datetime,
        type_: models.V3IncidentsExportFormat,
        owner_id: str,
        status: Optional[List[str]] = None,
        services: Optional[List[str]] = None,
        sources: Optional[List[str]] = None,
        assigned_to: Optional[List[str]] = None,
        assigned_to_user_i_ds_and_their_squads: Optional[List[str]] = None,
        service_owner: Optional[str] = None,
        priority: Optional[List[models.V3IncidentsIncidentPriority]] = None,
        tags: Optional[List[str]] = None,
        slo_affecting: Optional[
            models.V3IncidentsIncidentExportRequestSloAffecting
        ] = None,
        slos: Optional[List[int]] = None,
        is_starred: Optional[models.V3IncidentsIncidentExportRequestIsStarred] = None,
        text_filter: Optional[str] = None,
        notes: Optional[models.V3IncidentsIncidentExportRequestNotes] = None,
        retrospectives: Optional[
            models.V3IncidentsIncidentExportRequestRetrospectives
        ] = None,
        sort_by: Optional[models.V3IncidentsIncidentExportRequestSortBy] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Incident Export

        - This endpoint is used to export the incident details into a `csv` or `json` file.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.
        - Header field/value: `Content-Type`: `text/csv`


        Query Params:

        ```
        type: csv or json
        start_time: filter by date range
        end_time: filter by date range
        services: filter by services
        sources: filter by alert sources
        assigned_to: filter by assignee
        status: filter by incident status
        slo_affecting: filetr by slo affected
        slos: filter by slos
        tags: filter by tags key=value

        ```

        :param start_time:
        :param end_time:
        :param type: Defines the format of the export.
        :param owner_id:
        :param status:
        :param services:
        :param sources:
        :param assigned_to:
        :param assigned_to_user_i_ds_and_their_squads:
        :param service_owner:
        :param priority:
        :param tags:
        :param slo_affecting:
        :param slos:
        :param is_starred:
        :param text_filter:
        :param notes:
        :param retrospectives:
        :param sort_by:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsIncidentExportRequest(
            start_time=start_time,
            end_time=end_time,
            type=type_,
            owner_id=owner_id,
            status=status,
            services=services,
            sources=sources,
            assigned_to=assigned_to,
            assigned_to_user_i_ds_and_their_squads=assigned_to_user_i_ds_and_their_squads,
            service_owner=service_owner,
            priority=priority,
            tags=tags,
            slo_affecting=slo_affecting,
            slos=slos,
            is_starred=is_starred,
            text_filter=text_filter,
            notes=notes,
            retrospectives=retrospectives,
            sort_by=sort_by,
        )

        req = self._build_request_async(
            method="GET",
            path="/v3/incidents/export",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_incidentExport",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "2XX", "*"):
            return
        if utils.match_response(http_res, ["400", "401", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def bulk_update_priority(
        self,
        *,
        incident_ids: List[str],
        priority: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> bytes:
        r"""Bulk Incidents Priority Update

        - This endpoint is used to bulk update incident priority.

        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_ids:
        :param priority:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3IncidentsBulkIncidentsPriorityUpdateRequest(
            incident_ids=incident_ids,
            priority=priority,
        )

        req = self._build_request(
            method="PUT",
            path="/v3/incidents/priority",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="*/*",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.V3IncidentsBulkIncidentsPriorityUpdateRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_bulkIncidentsPriorityUpdate",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*/*"):
            http_res_bytes = utils.stream_to_bytes(http_res)
            return http_res_bytes
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def bulk_update_priority_async(
        self,
        *,
        incident_ids: List[str],
        priority: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> bytes:
        r"""Bulk Incidents Priority Update

        - This endpoint is used to bulk update incident priority.

        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_ids:
        :param priority:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3IncidentsBulkIncidentsPriorityUpdateRequest(
            incident_ids=incident_ids,
            priority=priority,
        )

        req = self._build_request_async(
            method="PUT",
            path="/v3/incidents/priority",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="*/*",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.V3IncidentsBulkIncidentsPriorityUpdateRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_bulkIncidentsPriorityUpdate",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*/*"):
            http_res_bytes = await utils.stream_to_bytes_async(http_res)
            return http_res_bytes
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def bulk_resolve(
        self,
        *,
        incident_ids: List[str],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Bulk Resolve Incidents

        - This endpoint is used to bulk resolve the incident by IDs.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_ids:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3IncidentsBulkIncidentIDsRequest(
            incident_ids=incident_ids,
        )

        req = self._build_request(
            method="POST",
            path="/v3/incidents/resolve",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.V3IncidentsBulkIncidentIDsRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_bulkResolveIncidents",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsBulkResolveIncidentsResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def bulk_resolve_async(
        self,
        *,
        incident_ids: List[str],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Bulk Resolve Incidents

        - This endpoint is used to bulk resolve the incident by IDs.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_ids:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3IncidentsBulkIncidentIDsRequest(
            incident_ids=incident_ids,
        )

        req = self._build_request_async(
            method="POST",
            path="/v3/incidents/resolve",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.V3IncidentsBulkIncidentIDsRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_bulkResolveIncidents",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsBulkResolveIncidentsResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def get_by_id(
        self,
        *,
        incident_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3IncidentsIncidentResponse:
        r"""Get Incident by ID

        - This endpoint is used to get the incident details by ID.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsGetIncidentByIDRequest(
            incident_id=incident_id,
        )

        req = self._build_request(
            method="GET",
            path="/v3/incidents/{incidentID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_getIncidentById",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsGetIncidentByIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def get_by_id_async(
        self,
        *,
        incident_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3IncidentsIncidentResponse:
        r"""Get Incident by ID

        - This endpoint is used to get the incident details by ID.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsGetIncidentByIDRequest(
            incident_id=incident_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v3/incidents/{incidentID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_getIncidentById",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsGetIncidentByIDResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def acknowledge(
        self,
        *,
        incident_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Acknowledge Incident

        - This endpoint is used to acknowledge the incident by ID.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsAcknowledgeIncidentRequest(
            incident_id=incident_id,
        )

        req = self._build_request(
            method="POST",
            path="/v3/incidents/{incidentID}/acknowledge",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_acknowledgeIncident",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsAcknowledgeIncidentResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def acknowledge_async(
        self,
        *,
        incident_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Acknowledge Incident

        - This endpoint is used to acknowledge the incident by ID.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsAcknowledgeIncidentRequest(
            incident_id=incident_id,
        )

        req = self._build_request_async(
            method="POST",
            path="/v3/incidents/{incidentID}/acknowledge",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_acknowledgeIncident",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsAcknowledgeIncidentResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def mark_slo_false_positive(
        self,
        *,
        incident_id: str,
        value: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.IncidentsMarkIncidentSloFalsePositiveResponse:
        r"""Mark Incident SLO False Positive

        - This endpoint is used to mark incident slo false positive.

        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_id:
        :param value:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsMarkIncidentSloFalsePositiveRequest(
            incident_id=incident_id,
            value=value,
        )

        req = self._build_request(
            method="PATCH",
            path="/v3/incidents/{incidentID}/mark-slo-incident-false-postive/{value}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_markIncidentSloFalsePositive",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsMarkIncidentSloFalsePositiveResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def mark_slo_false_positive_async(
        self,
        *,
        incident_id: str,
        value: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.IncidentsMarkIncidentSloFalsePositiveResponse:
        r"""Mark Incident SLO False Positive

        - This endpoint is used to mark incident slo false positive.

        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_id:
        :param value:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsMarkIncidentSloFalsePositiveRequest(
            incident_id=incident_id,
            value=value,
        )

        req = self._build_request_async(
            method="PATCH",
            path="/v3/incidents/{incidentID}/mark-slo-incident-false-postive/{value}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_markIncidentSloFalsePositive",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsMarkIncidentSloFalsePositiveResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def update_priority(
        self,
        *,
        incident_id: str,
        priority: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3IncidentsIncidentPriorityUpdateResponse:
        r"""Incident Priority Update

        - This endpoint is used to update incident priority by ID.

        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_id:
        :param priority:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsIncidentPriorityUpdateRequest(
            incident_id=incident_id,
            v3_incidents_incident_priority_update_request=models.V3IncidentsIncidentPriorityUpdateRequest(
                priority=priority,
            ),
        )

        req = self._build_request(
            method="PATCH",
            path="/v3/incidents/{incidentID}/priority",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v3_incidents_incident_priority_update_request,
                False,
                False,
                "json",
                models.V3IncidentsIncidentPriorityUpdateRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_incidentPriorityUpdate",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsIncidentPriorityUpdateResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def update_priority_async(
        self,
        *,
        incident_id: str,
        priority: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3IncidentsIncidentPriorityUpdateResponse:
        r"""Incident Priority Update

        - This endpoint is used to update incident priority by ID.

        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        :param incident_id:
        :param priority:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsIncidentPriorityUpdateRequest(
            incident_id=incident_id,
            v3_incidents_incident_priority_update_request=models.V3IncidentsIncidentPriorityUpdateRequest(
                priority=priority,
            ),
        )

        req = self._build_request_async(
            method="PATCH",
            path="/v3/incidents/{incidentID}/priority",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v3_incidents_incident_priority_update_request,
                False,
                False,
                "json",
                models.V3IncidentsIncidentPriorityUpdateRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_incidentPriorityUpdate",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsIncidentPriorityUpdateResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def reassign(
        self,
        *,
        incident_id: str,
        reassign_to: Union[models.ReassignTo, models.ReassignToTypedDict],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Reassign Incident

        - This endpoint is used to reassign the unresolved incident to any user or escalation policy or squads by ID.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.
        - `type` can be either `user` or `escalationpolicy` or `squad`

        :param incident_id:
        :param reassign_to:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsReassignIncidentRequest(
            incident_id=incident_id,
            v3_incidents_reassign_incident_request=models.V3IncidentsReassignIncidentRequest(
                reassign_to=utils.get_pydantic_model(reassign_to, models.ReassignTo),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v3/incidents/{incidentID}/reassign",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v3_incidents_reassign_incident_request,
                False,
                False,
                "json",
                models.V3IncidentsReassignIncidentRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_reassignIncident",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsReassignIncidentResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def reassign_async(
        self,
        *,
        incident_id: str,
        reassign_to: Union[models.ReassignTo, models.ReassignToTypedDict],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Reassign Incident

        - This endpoint is used to reassign the unresolved incident to any user or escalation policy or squads by ID.
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.
        - `type` can be either `user` or `escalationpolicy` or `squad`

        :param incident_id:
        :param reassign_to:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsReassignIncidentRequest(
            incident_id=incident_id,
            v3_incidents_reassign_incident_request=models.V3IncidentsReassignIncidentRequest(
                reassign_to=utils.get_pydantic_model(reassign_to, models.ReassignTo),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v3/incidents/{incidentID}/reassign",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v3_incidents_reassign_incident_request,
                False,
                False,
                "json",
                models.V3IncidentsReassignIncidentRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_reassignIncident",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsReassignIncidentResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def resolve(
        self,
        *,
        incident_id: str,
        resolution_reason: Union[
            models.ResolutionReason, models.ResolutionReasonTypedDict
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Resolve Incident

        - This endpoint is used to resolve the incident by ID.

        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        - Resolution Reason is mandatory / optional based on the organization feature settings (Only for Premium and Enterprise Orgs) [Read more](https://support.squadcast.com/incidents-page/incidents-details#understanding-resolution-reason)

        :param incident_id:
        :param resolution_reason:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsResolveIncidentRequest(
            incident_id=incident_id,
            v3_incidents_resolve_incident_request=models.V3IncidentsResolveIncidentRequest(
                resolution_reason=utils.get_pydantic_model(
                    resolution_reason, models.ResolutionReason
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v3/incidents/{incidentID}/resolve",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v3_incidents_resolve_incident_request,
                False,
                False,
                "json",
                models.V3IncidentsResolveIncidentRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_resolveIncident",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsResolveIncidentResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def resolve_async(
        self,
        *,
        incident_id: str,
        resolution_reason: Union[
            models.ResolutionReason, models.ResolutionReasonTypedDict
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> str:
        r"""Resolve Incident

        - This endpoint is used to resolve the incident by ID.

        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        - Resolution Reason is mandatory / optional based on the organization feature settings (Only for Premium and Enterprise Orgs) [Read more](https://support.squadcast.com/incidents-page/incidents-details#understanding-resolution-reason)

        :param incident_id:
        :param resolution_reason:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentsResolveIncidentRequest(
            incident_id=incident_id,
            v3_incidents_resolve_incident_request=models.V3IncidentsResolveIncidentRequest(
                resolution_reason=utils.get_pydantic_model(
                    resolution_reason, models.ResolutionReason
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v3/incidents/{incidentID}/resolve",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v3_incidents_resolve_incident_request,
                False,
                False,
                "json",
                models.V3IncidentsResolveIncidentRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_resolveIncident",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsResolveIncidentResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def get_status_by_request_ids(
        self,
        *,
        request_ids: List[str],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.IncidentsGetIncidentsStatusByRequestidsResponse:
        r"""Get Incidents Status By RequestIDs

        - This endpoint is used to get the status of incidents given list of request_ids
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        # Response
        - The response contains the mapping from `request_ids` to incident status.
        - `status` field can be one of - `suppressed`, `discarded`, `deduplicated`, `created`, `error`.
        -  status is `error` if the `request_id` is invalid. Both `incident_id` and `event_id` field won't be present if `status` is `error`
        -  status is `suppressed` if the incident was suppressed due to suppression rules.
        -  status is `deduplicated` if the incident was deduplicated due to deduplication rules.
        -  status is `discarded` if the incident was discarded due to some deduplication rule. `incident_id` field won't be present if `status` is `discarded`.
        -  otherwise, the status is `created`

        :param request_ids:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3IncidentsIngestionStatusRequest(
            request_ids=request_ids,
        )

        req = self._build_request(
            method="POST",
            path="/v3/requests/status",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.V3IncidentsIngestionStatusRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_getIncidentsStatusByRequestids",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsGetIncidentsStatusByRequestidsResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def get_status_by_request_ids_async(
        self,
        *,
        request_ids: List[str],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.IncidentsGetIncidentsStatusByRequestidsResponse:
        r"""Get Incidents Status By RequestIDs

        - This endpoint is used to get the status of incidents given list of request_ids
        - Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header.

        # Response
        - The response contains the mapping from `request_ids` to incident status.
        - `status` field can be one of - `suppressed`, `discarded`, `deduplicated`, `created`, `error`.
        -  status is `error` if the `request_id` is invalid. Both `incident_id` and `event_id` field won't be present if `status` is `error`
        -  status is `suppressed` if the incident was suppressed due to suppression rules.
        -  status is `deduplicated` if the incident was deduplicated due to deduplication rules.
        -  status is `discarded` if the incident was discarded due to some deduplication rule. `incident_id` field won't be present if `status` is `discarded`.
        -  otherwise, the status is `created`

        :param request_ids:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3IncidentsIngestionStatusRequest(
            request_ids=request_ids,
        )

        req = self._build_request_async(
            method="POST",
            path="/v3/requests/status",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.V3IncidentsIngestionStatusRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Incidents_getIncidentsStatusByRequestids",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentsGetIncidentsStatusByRequestidsResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)
