"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .sdkconfiguration import SDKConfiguration
from squadcast_sdk import errors, models, utils
from squadcast_sdk._hooks import HookContext
from squadcast_sdk.jira import Jira
from squadcast_sdk.servicenow import ServiceNow
from squadcast_sdk.types import OptionalNullable, UNSET
from squadcast_sdk.utils.unmarshal_json_response import unmarshal_json_response
from squadcast_sdk.webhook import Webhook
from typing import Any, Mapping, Optional


class IncidentsActions(BaseSDK):
    jira: Jira
    service_now: ServiceNow
    webhook: Webhook

    def __init__(
        self, sdk_config: SDKConfiguration, parent_ref: Optional[object] = None
    ) -> None:
        BaseSDK.__init__(self, sdk_config, parent_ref=parent_ref)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self):
        self.jira = Jira(self.sdk_configuration, parent_ref=self.parent_ref)
        self.service_now = ServiceNow(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.webhook = Webhook(self.sdk_configuration, parent_ref=self.parent_ref)

    def rebuild_circleci_project(
        self,
        *,
        incident_id: str,
        build_number: str,
        vcs_type: str,
        username: str,
        reponame: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3IncidentsIncidentActionsCircleCIRebuildResponse:
        r"""Rebuild a Project In CircleCI

        :param incident_id:
        :param build_number:
        :param vcs_type:
        :param username:
        :param reponame:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentActionsRebuildAProjectInCircleciRequest(
            incident_id=incident_id,
            build_number=build_number,
            v3_incidents_incident_actions_rebuild_circle_ci_project_request=models.V3IncidentsIncidentActionsRebuildCircleCIProjectRequest(
                vcs_type=vcs_type,
                username=username,
                reponame=reponame,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v3/incidents/{incidentID}/actions/circleci/rebuild/{buildNumber}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v3_incidents_incident_actions_rebuild_circle_ci_project_request,
                False,
                False,
                "json",
                models.V3IncidentsIncidentActionsRebuildCircleCIProjectRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="IncidentActions_rebuildAProjectInCircleci",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentActionsRebuildAProjectInCircleciResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.BadRequestUnion, http_res)
            raise errors.BadRequest(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def rebuild_circleci_project_async(
        self,
        *,
        incident_id: str,
        build_number: str,
        vcs_type: str,
        username: str,
        reponame: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3IncidentsIncidentActionsCircleCIRebuildResponse:
        r"""Rebuild a Project In CircleCI

        :param incident_id:
        :param build_number:
        :param vcs_type:
        :param username:
        :param reponame:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.IncidentActionsRebuildAProjectInCircleciRequest(
            incident_id=incident_id,
            build_number=build_number,
            v3_incidents_incident_actions_rebuild_circle_ci_project_request=models.V3IncidentsIncidentActionsRebuildCircleCIProjectRequest(
                vcs_type=vcs_type,
                username=username,
                reponame=reponame,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v3/incidents/{incidentID}/actions/circleci/rebuild/{buildNumber}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v3_incidents_incident_actions_rebuild_circle_ci_project_request,
                False,
                False,
                "json",
                models.V3IncidentsIncidentActionsRebuildCircleCIProjectRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="IncidentActions_rebuildAProjectInCircleci",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.IncidentActionsRebuildAProjectInCircleciResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.BadRequestUnion, http_res)
            raise errors.BadRequest(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)
