"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3_incidents_incidenteventresponse import (
    V3IncidentsIncidentEventResponse,
    V3IncidentsIncidentEventResponseTypedDict,
)
import pydantic
from squadcast_sdk.types import BaseModel
from squadcast_sdk.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class IncidentsGetIncidentEventsRequestTypedDict(TypedDict):
    incident_id: str
    offset: str
    r"""non zero value"""
    limit: str
    r"""non zero value, maximum is 10"""
    sort: str
    r"""sort it by either asc or desc"""
    deduped: str
    r"""if set to true, it will return only the deduped events.

    if set to false, it will return only the non-deduped event.

    otherwise it will return all the events
    """


class IncidentsGetIncidentEventsRequest(BaseModel):
    incident_id: Annotated[
        str,
        pydantic.Field(alias="incidentID"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]

    offset: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""non zero value"""

    limit: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""non zero value, maximum is 10"""

    sort: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""sort it by either asc or desc"""

    deduped: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""if set to true, it will return only the deduped events.

    if set to false, it will return only the non-deduped event.

    otherwise it will return all the events
    """


class IncidentsGetIncidentEventsDataTypedDict(TypedDict):
    events: List[V3IncidentsIncidentEventResponseTypedDict]


class IncidentsGetIncidentEventsData(BaseModel):
    events: List[V3IncidentsIncidentEventResponse]


class IncidentsGetIncidentEventsMetaTypedDict(TypedDict):
    total: int
    count: int
    current: str
    next: NotRequired[str]


class IncidentsGetIncidentEventsMeta(BaseModel):
    total: int

    count: int

    current: str

    next: Optional[str] = None


class IncidentsGetIncidentEventsResponseTypedDict(TypedDict):
    r"""The request has succeeded."""

    data: IncidentsGetIncidentEventsDataTypedDict
    meta: IncidentsGetIncidentEventsMetaTypedDict


class IncidentsGetIncidentEventsResponse(BaseModel):
    r"""The request has succeeded."""

    data: IncidentsGetIncidentEventsData

    meta: IncidentsGetIncidentEventsMeta
