"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3_incidents_exportformat import V3IncidentsExportFormat
from .v3_incidents_incidentexportrequest_is_starred import (
    V3IncidentsIncidentExportRequestIsStarred,
)
from .v3_incidents_incidentexportrequest_notes import (
    V3IncidentsIncidentExportRequestNotes,
)
from .v3_incidents_incidentexportrequest_retrospectives import (
    V3IncidentsIncidentExportRequestRetrospectives,
)
from .v3_incidents_incidentexportrequest_slo_affecting import (
    V3IncidentsIncidentExportRequestSloAffecting,
)
from .v3_incidents_incidentexportrequest_sort_by import (
    V3IncidentsIncidentExportRequestSortBy,
)
from .v3_incidents_incidentpriority import V3IncidentsIncidentPriority
from datetime import datetime
import pydantic
from squadcast_sdk.types import BaseModel
from squadcast_sdk.utils import FieldMetadata, QueryParamMetadata
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class IncidentsIncidentExportRequestTypedDict(TypedDict):
    start_time: datetime
    end_time: datetime
    type: V3IncidentsExportFormat
    r"""Defines the format of the export."""
    owner_id: str
    status: NotRequired[List[str]]
    services: NotRequired[List[str]]
    sources: NotRequired[List[str]]
    assigned_to: NotRequired[List[str]]
    assigned_to_user_i_ds_and_their_squads: NotRequired[List[str]]
    service_owner: NotRequired[str]
    priority: NotRequired[List[V3IncidentsIncidentPriority]]
    tags: NotRequired[List[str]]
    slo_affecting: NotRequired[V3IncidentsIncidentExportRequestSloAffecting]
    slos: NotRequired[List[int]]
    is_starred: NotRequired[V3IncidentsIncidentExportRequestIsStarred]
    text_filter: NotRequired[str]
    notes: NotRequired[V3IncidentsIncidentExportRequestNotes]
    retrospectives: NotRequired[V3IncidentsIncidentExportRequestRetrospectives]
    sort_by: NotRequired[V3IncidentsIncidentExportRequestSortBy]


class IncidentsIncidentExportRequest(BaseModel):
    start_time: Annotated[
        datetime, FieldMetadata(query=QueryParamMetadata(style="form", explode=False))
    ]

    end_time: Annotated[
        datetime, FieldMetadata(query=QueryParamMetadata(style="form", explode=False))
    ]

    type: Annotated[
        V3IncidentsExportFormat,
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ]
    r"""Defines the format of the export."""

    owner_id: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=False))
    ]

    status: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    services: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    sources: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    assigned_to: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    assigned_to_user_i_ds_and_their_squads: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="assignedToUserIDsAndTheirSquads"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    service_owner: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    priority: Annotated[
        Optional[List[V3IncidentsIncidentPriority]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    tags: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    slo_affecting: Annotated[
        Optional[V3IncidentsIncidentExportRequestSloAffecting],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    slos: Annotated[
        Optional[List[int]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    is_starred: Annotated[
        Optional[V3IncidentsIncidentExportRequestIsStarred],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    text_filter: Annotated[
        Optional[str],
        pydantic.Field(alias="textFilter"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    notes: Annotated[
        Optional[V3IncidentsIncidentExportRequestNotes],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    retrospectives: Annotated[
        Optional[V3IncidentsIncidentExportRequestRetrospectives],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    sort_by: Annotated[
        Optional[V3IncidentsIncidentExportRequestSortBy],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None
