"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .common_v4_pageinfo import CommonV4PageInfo, CommonV4PageInfoTypedDict
from .v4_scheduleresponse import V4ScheduleResponse, V4ScheduleResponseTypedDict
import pydantic
from squadcast_sdk.types import BaseModel
from squadcast_sdk.utils import FieldMetadata, QueryParamMetadata
from typing import Callable, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SchedulesListSchedulesRequestTypedDict(TypedDict):
    team_id: str
    schedule_i_ds: NotRequired[List[int]]
    participants: NotRequired[List[str]]
    schedule_name: NotRequired[str]
    my_on_call: NotRequired[bool]
    you_and_your_squads: NotRequired[bool]
    search: NotRequired[str]
    hide_paused: NotRequired[bool]
    owner_id: NotRequired[str]
    escalation_policies: NotRequired[List[str]]
    without_escalation_policy: NotRequired[bool]
    page_size: NotRequired[int]
    cursor: NotRequired[str]


class SchedulesListSchedulesRequest(BaseModel):
    team_id: Annotated[
        str,
        pydantic.Field(alias="teamID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ]

    schedule_i_ds: Annotated[
        Optional[List[int]],
        pydantic.Field(alias="scheduleIDs"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    participants: Annotated[
        Optional[List[str]],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    schedule_name: Annotated[
        Optional[str],
        pydantic.Field(alias="scheduleName"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    my_on_call: Annotated[
        Optional[bool],
        pydantic.Field(alias="myOnCall"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    you_and_your_squads: Annotated[
        Optional[bool],
        pydantic.Field(alias="youAndYourSquads"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    search: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    hide_paused: Annotated[
        Optional[bool],
        pydantic.Field(alias="hidePaused"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    owner_id: Annotated[
        Optional[str],
        pydantic.Field(alias="ownerID"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    escalation_policies: Annotated[
        Optional[List[str]],
        pydantic.Field(alias="escalationPolicies"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    without_escalation_policy: Annotated[
        Optional[bool],
        pydantic.Field(alias="withoutEscalationPolicy"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    page_size: Annotated[
        Optional[int],
        pydantic.Field(alias="pageSize"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None

    cursor: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=False)),
    ] = None


class SchedulesListSchedulesResponseBodyTypedDict(TypedDict):
    r"""The request has succeeded."""

    data: List[V4ScheduleResponseTypedDict]
    page_info: CommonV4PageInfoTypedDict


class SchedulesListSchedulesResponseBody(BaseModel):
    r"""The request has succeeded."""

    data: List[V4ScheduleResponse]

    page_info: Annotated[CommonV4PageInfo, pydantic.Field(alias="pageInfo")]


class SchedulesListSchedulesResponseTypedDict(TypedDict):
    result: SchedulesListSchedulesResponseBodyTypedDict


class SchedulesListSchedulesResponse(BaseModel):
    next: Callable[[], Optional[SchedulesListSchedulesResponse]]

    result: SchedulesListSchedulesResponseBody
