"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3_auditlogs_actor import V3AuditLogsActor, V3AuditLogsActorTypedDict
from .v3_auditlogs_team import V3AuditLogsTeam, V3AuditLogsTeamTypedDict
import pydantic
from pydantic import model_serializer
from squadcast_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing_extensions import Annotated, NotRequired, TypedDict


class V3AuditLogsAuditLogIDResponseMetaTypedDict(TypedDict):
    pass


class V3AuditLogsAuditLogIDResponseMeta(BaseModel):
    pass


class V3AuditLogsAuditLogIDResponseTypedDict(TypedDict):
    r"""Represents detailed audit log entry response"""

    id: int
    resource: str
    action: str
    actor: V3AuditLogsActorTypedDict
    r"""Represents an actor (user) in audit logs"""
    client: str
    timestamp: str
    timezone: str
    team: V3AuditLogsTeamTypedDict
    r"""Represents a team in audit logs"""
    token_type: str
    ip_address: str
    additional_info: str
    user_agent: str
    meta: NotRequired[Nullable[V3AuditLogsAuditLogIDResponseMetaTypedDict]]


class V3AuditLogsAuditLogIDResponse(BaseModel):
    r"""Represents detailed audit log entry response"""

    id: int

    resource: str

    action: str

    actor: V3AuditLogsActor
    r"""Represents an actor (user) in audit logs"""

    client: str

    timestamp: str

    timezone: str

    team: V3AuditLogsTeam
    r"""Represents a team in audit logs"""

    token_type: Annotated[str, pydantic.Field(alias="tokenType")]

    ip_address: Annotated[str, pydantic.Field(alias="ipAddress")]

    additional_info: Annotated[str, pydantic.Field(alias="additionalInfo")]

    user_agent: Annotated[str, pydantic.Field(alias="userAgent")]

    meta: OptionalNullable[V3AuditLogsAuditLogIDResponseMeta] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
