"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import date
import pydantic
from squadcast_sdk.types import BaseModel
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class FiltersTypedDict(TypedDict):
    start_date: date
    end_date: date
    resource: NotRequired[List[str]]
    action: NotRequired[List[str]]
    actor: NotRequired[List[str]]
    team: NotRequired[List[str]]
    client: NotRequired[List[str]]


class Filters(BaseModel):
    start_date: Annotated[date, pydantic.Field(alias="startDate")]

    end_date: Annotated[date, pydantic.Field(alias="endDate")]

    resource: Optional[List[str]] = None

    action: Optional[List[str]] = None

    actor: Optional[List[str]] = None

    team: Optional[List[str]] = None

    client: Optional[List[str]] = None


ExportType = Literal[
    "csv",
    "json",
]


class V3AuditLogsExportAuditLogsRequestTypedDict(TypedDict):
    r"""Request model for exporting audit logs"""

    filters: FiltersTypedDict
    name: str
    export_type: ExportType
    description: NotRequired[str]


class V3AuditLogsExportAuditLogsRequest(BaseModel):
    r"""Request model for exporting audit logs"""

    filters: Filters

    name: str

    export_type: Annotated[ExportType, pydantic.Field(alias="exportType")]

    description: Optional[str] = None
