"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3_auditlogs_actor import V3AuditLogsActor, V3AuditLogsActorTypedDict
from .v3_auditlogs_team import V3AuditLogsTeam, V3AuditLogsTeamTypedDict
from datetime import date
import pydantic
from pydantic import model_serializer
from squadcast_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List
from typing_extensions import Annotated, NotRequired, TypedDict


class V3AuditLogsFiltersTypedDict(TypedDict):
    r"""Represents filters used in audit log queries"""

    start_date: date
    end_date: date
    resource: NotRequired[Nullable[List[str]]]
    action: NotRequired[Nullable[List[str]]]
    actor: NotRequired[Nullable[List[V3AuditLogsActorTypedDict]]]
    team: NotRequired[Nullable[List[V3AuditLogsTeamTypedDict]]]
    client: NotRequired[Nullable[List[str]]]


class V3AuditLogsFilters(BaseModel):
    r"""Represents filters used in audit log queries"""

    start_date: Annotated[date, pydantic.Field(alias="startDate")]

    end_date: Annotated[date, pydantic.Field(alias="endDate")]

    resource: OptionalNullable[List[str]] = UNSET

    action: OptionalNullable[List[str]] = UNSET

    actor: OptionalNullable[List[V3AuditLogsActor]] = UNSET

    team: OptionalNullable[List[V3AuditLogsTeam]] = UNSET

    client: OptionalNullable[List[str]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["resource", "action", "actor", "team", "client"]
        nullable_fields = ["resource", "action", "actor", "team", "client"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
