"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .common_v3_entityowner import CommonV3EntityOwner, CommonV3EntityOwnerTypedDict
from .v3_escalationpolicies_escalationpolicyrule import (
    V3EscalationPoliciesEscalationPolicyRule,
    V3EscalationPoliciesEscalationPolicyRuleTypedDict,
)
from .v3_escalationpolicies_incidentreminderrule import (
    V3EscalationPoliciesIncidentReminderRule,
    V3EscalationPoliciesIncidentReminderRuleTypedDict,
)
from squadcast_sdk.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class V3EscalationPoliciesCreateEscalationPolicyRequestTypedDict(TypedDict):
    owner_id: str
    r"""The ID of the team that owns this escalation policy."""
    name: str
    r"""The name of the escalation policy."""
    description: str
    r"""A description of the escalation policy."""
    repetition: int
    r"""The number of times the entire policy should be repeated."""
    repeat_after: int
    r"""The time in minutes after which the policy should be repeated."""
    rules: List[V3EscalationPoliciesEscalationPolicyRuleTypedDict]
    r"""The rules that define the escalation steps."""
    enable_incident_reminders: bool
    r"""Enable or disable incident reminders."""
    incident_reminder_rules: List[V3EscalationPoliciesIncidentReminderRuleTypedDict]
    r"""The rules for incident reminders."""
    enable_incident_retrigger: bool
    r"""Enable or disable automatic incident re-triggering."""
    retrigger_after: int
    r"""The time in hours after which an incident should be re-triggered."""
    entity_owner: NotRequired[CommonV3EntityOwnerTypedDict]
    r"""The owner of the entity."""


class V3EscalationPoliciesCreateEscalationPolicyRequest(BaseModel):
    owner_id: str
    r"""The ID of the team that owns this escalation policy."""

    name: str
    r"""The name of the escalation policy."""

    description: str
    r"""A description of the escalation policy."""

    repetition: int
    r"""The number of times the entire policy should be repeated."""

    repeat_after: int
    r"""The time in minutes after which the policy should be repeated."""

    rules: List[V3EscalationPoliciesEscalationPolicyRule]
    r"""The rules that define the escalation steps."""

    enable_incident_reminders: bool
    r"""Enable or disable incident reminders."""

    incident_reminder_rules: List[V3EscalationPoliciesIncidentReminderRule]
    r"""The rules for incident reminders."""

    enable_incident_retrigger: bool
    r"""Enable or disable automatic incident re-triggering."""

    retrigger_after: int
    r"""The time in hours after which an incident should be re-triggered."""

    entity_owner: Optional[CommonV3EntityOwner] = None
    r"""The owner of the entity."""
