"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3_escalationpolicies_escalationentity import (
    V3EscalationPoliciesEscalationEntity,
    V3EscalationPoliciesEscalationEntityTypedDict,
)
import pydantic
from squadcast_sdk.types import BaseModel
from typing import List
from typing_extensions import Annotated, TypedDict


class V3EscalationPoliciesEscalationPolicyRuleTypedDict(TypedDict):
    r"""Represents a rule within an escalation policy."""

    escalation_time: int
    r"""The time in minutes to wait before this rule is triggered."""
    via: List[str]
    r"""The notification methods to use for this rule."""
    roundrobin_enabled: bool
    r"""Indicates if round-robin is enabled for the entities in this rule."""
    roundrobin_next_index: int
    r"""The index of the next entity to be notified in a round-robin setup."""
    entities: List[V3EscalationPoliciesEscalationEntityTypedDict]
    r"""The entities to be notified in this rule."""
    escalate_within_roundrobin: bool
    r"""Indicates if escalation should happen within the round-robin rotation."""
    repetition: int
    r"""The number of times this specific rule should be repeated."""
    repeat_after: int
    r"""The time in minutes after which this rule should be repeated."""


class V3EscalationPoliciesEscalationPolicyRule(BaseModel):
    r"""Represents a rule within an escalation policy."""

    escalation_time: Annotated[int, pydantic.Field(alias="escalationTime")]
    r"""The time in minutes to wait before this rule is triggered."""

    via: List[str]
    r"""The notification methods to use for this rule."""

    roundrobin_enabled: bool
    r"""Indicates if round-robin is enabled for the entities in this rule."""

    roundrobin_next_index: int
    r"""The index of the next entity to be notified in a round-robin setup."""

    entities: List[V3EscalationPoliciesEscalationEntity]
    r"""The entities to be notified in this rule."""

    escalate_within_roundrobin: bool
    r"""Indicates if escalation should happen within the round-robin rotation."""

    repetition: int
    r"""The number of times this specific rule should be repeated."""

    repeat_after: int
    r"""The time in minutes after which this rule should be repeated."""
