"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3_extensions_msteams_squadcastservicemapping import (
    V3ExtensionsMSTeamsSquadCastServiceMapping,
    V3ExtensionsMSTeamsSquadCastServiceMappingTypedDict,
)
from squadcast_sdk.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class V3ExtensionsMSTeamsChannelConfigurationTypedDict(TypedDict):
    r"""Defines a mapping from a Squadcast Team/Service to a specific MS Teams channel."""

    squadcast_team_id: str
    r"""The MongoDB ObjectID of the corresponding team in Squadcast."""
    squadcast_team_name: str
    r"""The name of the corresponding team in Squadcast."""
    is_all_services: bool
    r"""If true, alerts for all services in the Squadcast Team are sent to this channel."""
    services: List[V3ExtensionsMSTeamsSquadCastServiceMappingTypedDict]
    r"""An array of specific services to route to this channel. Used when 'is_all_services' is false."""
    msteams_channel_id: str
    r"""The unique identifier of the target channel in MS Teams."""
    msteams_channel_name: str
    r"""The display name of the target channel in MS Teams."""
    id: NotRequired[str]
    r"""The MongoDB ObjectID for this specific channel configuration entry."""


class V3ExtensionsMSTeamsChannelConfiguration(BaseModel):
    r"""Defines a mapping from a Squadcast Team/Service to a specific MS Teams channel."""

    squadcast_team_id: str
    r"""The MongoDB ObjectID of the corresponding team in Squadcast."""

    squadcast_team_name: str
    r"""The name of the corresponding team in Squadcast."""

    is_all_services: bool
    r"""If true, alerts for all services in the Squadcast Team are sent to this channel."""

    services: List[V3ExtensionsMSTeamsSquadCastServiceMapping]
    r"""An array of specific services to route to this channel. Used when 'is_all_services' is false."""

    msteams_channel_id: str
    r"""The unique identifier of the target channel in MS Teams."""

    msteams_channel_name: str
    r"""The display name of the target channel in MS Teams."""

    id: Optional[str] = None
    r"""The MongoDB ObjectID for this specific channel configuration entry."""
