"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3_extensions_msteams_connectedteams import (
    V3ExtensionsMSTeamsConnectedTeams,
    V3ExtensionsMSTeamsConnectedTeamsTypedDict,
)
from .v3_extensions_msteams_incidentactionalertstate import (
    V3ExtensionsMSTeamsIncidentActionAlertState,
    V3ExtensionsMSTeamsIncidentActionAlertStateTypedDict,
)
from .v3_extensions_msteams_triggers import (
    V3ExtensionsMSTeamsTriggers,
    V3ExtensionsMSTeamsTriggersTypedDict,
)
from squadcast_sdk.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class V3ExtensionsMSTeamsCreateOrUpdateMSTeamsConfigRequestTypedDict(TypedDict):
    r"""The request body for creating or updating an MS Teams extension configuration."""

    default_conversation_name: str
    r"""The display name for the default conversation/channel."""
    default_conversation_id: str
    r"""The unique identifier for the default MS Teams conversation/channel."""
    is_active: bool
    r"""A master switch to enable or disable the entire integration."""
    is_default_active: bool
    r"""Determines if notifications should be sent to the default channel."""
    is_custom_channels_active: bool
    r"""Determines if notifications should be sent to custom-configured channels."""
    triggers: V3ExtensionsMSTeamsTriggersTypedDict
    r"""Configuration for which alerts are sent to the MS Teams channel."""
    tenant_id: str
    r"""The Azure AD Tenant ID of the organization that owns this extension."""
    from_id: str
    r"""The Azure AD Object ID of the user who created this extension."""
    connected_teams: List[V3ExtensionsMSTeamsConnectedTeamsTypedDict]
    r"""A list of all MS Teams (teams) connected to this organization."""
    custom_incident_alert_state: NotRequired[
        V3ExtensionsMSTeamsIncidentActionAlertStateTypedDict
    ]
    r"""A user-friendly way to configure which incident action alerts are active. This is translated by the backend into the 'triggers.custom' array."""
    id: NotRequired[str]
    r"""The MongoDB ObjectID of the extension document. Should be included for updates."""
    organization_id: NotRequired[str]
    r"""The MongoDB ObjectID of the organization this extension belongs to."""


class V3ExtensionsMSTeamsCreateOrUpdateMSTeamsConfigRequest(BaseModel):
    r"""The request body for creating or updating an MS Teams extension configuration."""

    default_conversation_name: str
    r"""The display name for the default conversation/channel."""

    default_conversation_id: str
    r"""The unique identifier for the default MS Teams conversation/channel."""

    is_active: bool
    r"""A master switch to enable or disable the entire integration."""

    is_default_active: bool
    r"""Determines if notifications should be sent to the default channel."""

    is_custom_channels_active: bool
    r"""Determines if notifications should be sent to custom-configured channels."""

    triggers: V3ExtensionsMSTeamsTriggers
    r"""Configuration for which alerts are sent to the MS Teams channel."""

    tenant_id: str
    r"""The Azure AD Tenant ID of the organization that owns this extension."""

    from_id: str
    r"""The Azure AD Object ID of the user who created this extension."""

    connected_teams: List[V3ExtensionsMSTeamsConnectedTeams]
    r"""A list of all MS Teams (teams) connected to this organization."""

    custom_incident_alert_state: Optional[
        V3ExtensionsMSTeamsIncidentActionAlertState
    ] = None
    r"""A user-friendly way to configure which incident action alerts are active. This is translated by the backend into the 'triggers.custom' array."""

    id: Optional[str] = None
    r"""The MongoDB ObjectID of the extension document. Should be included for updates."""

    organization_id: Optional[str] = None
    r"""The MongoDB ObjectID of the organization this extension belongs to."""
