"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3_extensions_webhooks_webhookfilter import (
    V3ExtensionsWebhooksWebhookFilter,
    V3ExtensionsWebhooksWebhookFilterTypedDict,
)
from .v3_extensions_webhooks_webhooktrigger import (
    V3ExtensionsWebhooksWebhookTrigger,
    V3ExtensionsWebhooksWebhookTriggerTypedDict,
)
from .v3_extensions_webhooks_webhookurl import (
    V3ExtensionsWebhooksWebhookURL,
    V3ExtensionsWebhooksWebhookURLTypedDict,
)
from pydantic import model_serializer
from squadcast_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class V3ExtensionsWebhooksWebhookHeaderTypedDict(TypedDict):
    pass


class V3ExtensionsWebhooksWebhookHeader(BaseModel):
    pass


class V3ExtensionsWebhooksWebhookTypedDict(TypedDict):
    name: str
    r"""Name of the webhook"""
    triggers: List[V3ExtensionsWebhooksWebhookTriggerTypedDict]
    r"""A list of triggers for this webhook"""
    urls: List[V3ExtensionsWebhooksWebhookURLTypedDict]
    r"""A list of URLs to which the webhook payload will be sent"""
    trigger_type: str
    r"""Type of trigger"""
    description: NotRequired[str]
    r"""Description of the webhook"""
    header: NotRequired[Nullable[V3ExtensionsWebhooksWebhookHeaderTypedDict]]
    r"""Headers to be sent with the webhook"""
    filters: NotRequired[Nullable[V3ExtensionsWebhooksWebhookFilterTypedDict]]
    r"""Filters to apply to the webhook"""
    max_retry: NotRequired[int]
    r"""Maximum number of retries for the webhook"""
    teams: NotRequired[Nullable[List[str]]]
    r"""List of team IDs to which this webhook is applicable"""
    is_all_teams_configured: NotRequired[bool]
    r"""Set to true if the webhook is configured for all teams"""
    custom_payload_template_slug: NotRequired[str]
    r"""Slug of the custom payload template"""
    language: NotRequired[str]
    r"""Language for the webhook payload"""
    mail_ids: NotRequired[Nullable[List[str]]]
    r"""List of email IDs for notification"""
    custom_payload: NotRequired[str]
    r"""Custom payload for the webhook"""
    payload_type: NotRequired[str]
    r"""Type of payload"""


class V3ExtensionsWebhooksWebhook(BaseModel):
    name: str
    r"""Name of the webhook"""

    triggers: List[V3ExtensionsWebhooksWebhookTrigger]
    r"""A list of triggers for this webhook"""

    urls: List[V3ExtensionsWebhooksWebhookURL]
    r"""A list of URLs to which the webhook payload will be sent"""

    trigger_type: str
    r"""Type of trigger"""

    description: Optional[str] = None
    r"""Description of the webhook"""

    header: OptionalNullable[V3ExtensionsWebhooksWebhookHeader] = UNSET
    r"""Headers to be sent with the webhook"""

    filters: OptionalNullable[V3ExtensionsWebhooksWebhookFilter] = UNSET
    r"""Filters to apply to the webhook"""

    max_retry: Optional[int] = None
    r"""Maximum number of retries for the webhook"""

    teams: OptionalNullable[List[str]] = UNSET
    r"""List of team IDs to which this webhook is applicable"""

    is_all_teams_configured: Optional[bool] = None
    r"""Set to true if the webhook is configured for all teams"""

    custom_payload_template_slug: Optional[str] = None
    r"""Slug of the custom payload template"""

    language: Optional[str] = None
    r"""Language for the webhook payload"""

    mail_ids: OptionalNullable[List[str]] = UNSET
    r"""List of email IDs for notification"""

    custom_payload: Optional[str] = None
    r"""Custom payload for the webhook"""

    payload_type: Optional[str] = None
    r"""Type of payload"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "header",
            "filters",
            "max_retry",
            "teams",
            "is_all_teams_configured",
            "custom_payload_template_slug",
            "language",
            "mail_ids",
            "custom_payload",
            "payload_type",
        ]
        nullable_fields = ["header", "filters", "teams", "mail_ids"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
