"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .common_v3_rbacentitypermission import (
    CommonV3RBACEntityPermission,
    CommonV3RBACEntityPermissionTypedDict,
)
from .common_v3_rbacowner import CommonV3RBACOwner, CommonV3RBACOwnerTypedDict
from .v3_incidents_additionalresponderdetails import (
    V3IncidentsAdditionalResponderDetails,
    V3IncidentsAdditionalResponderDetailsTypedDict,
)
from .v3_incidents_analytics import V3IncidentsAnalytics, V3IncidentsAnalyticsTypedDict
from .v3_incidents_assignedto import (
    V3IncidentsAssignedTo,
    V3IncidentsAssignedToTypedDict,
)
from .v3_incidents_dedupdata import V3IncidentsDedupData, V3IncidentsDedupDataTypedDict
from .v3_incidents_incidentpriority import V3IncidentsIncidentPriority
from .v3_incidents_logs import V3IncidentsLogs, V3IncidentsLogsTypedDict
from .v3_incidents_mergeincidententityreference import (
    V3IncidentsMergeIncidentEntityReference,
    V3IncidentsMergeIncidentEntityReferenceTypedDict,
)
from .v3_incidents_notificationdelaypolicy import (
    V3IncidentsNotificationDelayPolicy,
    V3IncidentsNotificationDelayPolicyTypedDict,
)
from .v3_incidents_pinnedmessage import (
    V3IncidentsPinnedMessage,
    V3IncidentsPinnedMessageTypedDict,
)
from .v3_incidents_relevantpeoplelog import (
    V3IncidentsRelevantPeopleLog,
    V3IncidentsRelevantPeopleLogTypedDict,
)
from .v3_incidents_responsenote import (
    V3IncidentsResponseNote,
    V3IncidentsResponseNoteTypedDict,
)
from .v3_incidents_snoozedetails import (
    V3IncidentsSnoozeDetails,
    V3IncidentsSnoozeDetailsTypedDict,
)
from datetime import datetime
import pydantic
from pydantic import model_serializer
from squadcast_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3IncidentsIncidentResponseTagsTypedDict(TypedDict):
    pass


class V3IncidentsIncidentResponseTags(BaseModel):
    pass


class V3IncidentsIncidentResponseRetriggerPolicyTypedDict(TypedDict):
    escalation_policy_id: str
    retrigger_at: NotRequired[datetime]
    retriggered_at: NotRequired[datetime]


class V3IncidentsIncidentResponseRetriggerPolicy(BaseModel):
    escalation_policy_id: Annotated[str, pydantic.Field(alias="escalationPolicyId")]

    retrigger_at: Annotated[Optional[datetime], pydantic.Field(alias="retriggerAt")] = (
        None
    )

    retriggered_at: Annotated[
        Optional[datetime], pydantic.Field(alias="retriggeredAt")
    ] = None


class V3IncidentsIncidentResponseTypedDict(TypedDict):
    r"""Represents an incident."""

    id: str
    service_id: str
    alert_source_id: str
    organization_id: str
    incident_number: int
    message: str
    assigned_to: List[V3IncidentsAssignedToTypedDict]
    additional_responders: List[V3IncidentsAdditionalResponderDetailsTypedDict]
    description: str
    status: str
    time_of_creation: datetime
    updated_at: datetime
    tags: V3IncidentsIncidentResponseTagsTypedDict
    logs: List[V3IncidentsLogsTypedDict]
    analytics: V3IncidentsAnalyticsTypedDict
    r"""Incident analytics data."""
    pinned_messages: Nullable[List[V3IncidentsPinnedMessageTypedDict]]
    deleted: bool
    event_count: int
    dedup_data: V3IncidentsDedupDataTypedDict
    r"""Deduplication data for an incident."""
    owner: CommonV3RBACOwnerTypedDict
    r"""Represents the RBAC owner of an entity."""
    access_control: Nullable[List[CommonV3RBACEntityPermissionTypedDict]]
    relevant_users: Nullable[List[str]]
    relevant_escalation_policies: Nullable[List[str]]
    relevant_squads: Nullable[List[str]]
    relevant_schedules: Nullable[List[str]]
    relevant_people_logs: Nullable[List[V3IncidentsRelevantPeopleLogTypedDict]]
    response_notes: Nullable[List[V3IncidentsResponseNoteTypedDict]]
    attachments: Nullable[List[str]]
    is_child: bool
    children: List[V3IncidentsMergeIncidentEntityReferenceTypedDict]
    did_auto_pause: bool
    did_auto_pause_timeout: bool
    auto_pause_ends_at: datetime
    manually_marked_transient_alert_feedback_type: str
    classification_id: int
    grouped_alert_count: int
    has_priority: bool
    snooze_details: V3IncidentsSnoozeDetailsTypedDict
    r"""Details about incident snoozing."""
    did_notification_delay: bool
    notification_delay_policy: V3IncidentsNotificationDelayPolicyTypedDict
    r"""Policy for delaying notifications."""
    digest_id: str
    slo_id: NotRequired[int]
    last_acknowledged_at: NotRequired[Nullable[datetime]]
    created_by: NotRequired[str]
    sender_email: NotRequired[str]
    retrigger_policy: NotRequired[
        Nullable[V3IncidentsIncidentResponseRetriggerPolicyTypedDict]
    ]
    webform_id: NotRequired[int]
    webform_submission_id: NotRequired[int]
    parent: NotRequired[V3IncidentsMergeIncidentEntityReferenceTypedDict]
    r"""Reference to a merged incident entity."""
    priority: NotRequired[V3IncidentsIncidentPriority]
    r"""Represents the priority of an incident."""


class V3IncidentsIncidentResponse(BaseModel):
    r"""Represents an incident."""

    id: str

    service_id: str

    alert_source_id: str

    organization_id: str

    incident_number: Annotated[int, pydantic.Field(alias="incidentNumber")]

    message: str

    assigned_to: Annotated[
        List[V3IncidentsAssignedTo], pydantic.Field(alias="assignedTo")
    ]

    additional_responders: List[V3IncidentsAdditionalResponderDetails]

    description: str

    status: str

    time_of_creation: Annotated[datetime, pydantic.Field(alias="timeOfCreation")]

    updated_at: datetime

    tags: V3IncidentsIncidentResponseTags

    logs: List[V3IncidentsLogs]

    analytics: V3IncidentsAnalytics
    r"""Incident analytics data."""

    pinned_messages: Nullable[List[V3IncidentsPinnedMessage]]

    deleted: bool

    event_count: int

    dedup_data: V3IncidentsDedupData
    r"""Deduplication data for an incident."""

    owner: CommonV3RBACOwner
    r"""Represents the RBAC owner of an entity."""

    access_control: Nullable[List[CommonV3RBACEntityPermission]]

    relevant_users: Annotated[
        Nullable[List[str]], pydantic.Field(alias="relevantUsers")
    ]

    relevant_escalation_policies: Annotated[
        Nullable[List[str]], pydantic.Field(alias="relevantEscalationPolicies")
    ]

    relevant_squads: Annotated[
        Nullable[List[str]], pydantic.Field(alias="relevantSquads")
    ]

    relevant_schedules: Annotated[
        Nullable[List[str]], pydantic.Field(alias="relevantSchedules")
    ]

    relevant_people_logs: Annotated[
        Nullable[List[V3IncidentsRelevantPeopleLog]],
        pydantic.Field(alias="relevantPeopleLogs"),
    ]

    response_notes: Annotated[
        Nullable[List[V3IncidentsResponseNote]], pydantic.Field(alias="responseNotes")
    ]

    attachments: Nullable[List[str]]

    is_child: bool

    children: List[V3IncidentsMergeIncidentEntityReference]

    did_auto_pause: bool

    did_auto_pause_timeout: bool

    auto_pause_ends_at: datetime

    manually_marked_transient_alert_feedback_type: str

    classification_id: int

    grouped_alert_count: int

    has_priority: bool

    snooze_details: V3IncidentsSnoozeDetails
    r"""Details about incident snoozing."""

    did_notification_delay: bool

    notification_delay_policy: V3IncidentsNotificationDelayPolicy
    r"""Policy for delaying notifications."""

    digest_id: str

    slo_id: Optional[int] = None

    last_acknowledged_at: OptionalNullable[datetime] = UNSET

    created_by: Optional[str] = None

    sender_email: Optional[str] = None

    retrigger_policy: Annotated[
        OptionalNullable[V3IncidentsIncidentResponseRetriggerPolicy],
        pydantic.Field(alias="retriggerPolicy"),
    ] = UNSET

    webform_id: Optional[int] = None

    webform_submission_id: Optional[int] = None

    parent: Optional[V3IncidentsMergeIncidentEntityReference] = None
    r"""Reference to a merged incident entity."""

    priority: Optional[V3IncidentsIncidentPriority] = None
    r"""Represents the priority of an incident."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "slo_id",
            "last_acknowledged_at",
            "created_by",
            "sender_email",
            "retriggerPolicy",
            "webform_id",
            "webform_submission_id",
            "parent",
            "priority",
        ]
        nullable_fields = [
            "last_acknowledged_at",
            "pinned_messages",
            "access_control",
            "relevantUsers",
            "relevantEscalationPolicies",
            "relevantSquads",
            "relevantSchedules",
            "relevantPeopleLogs",
            "responseNotes",
            "attachments",
            "retriggerPolicy",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
