"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
import pydantic
from pydantic import model_serializer
from squadcast_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3IncidentsLogsAdditionalInfoTypedDict(TypedDict):
    pass


class V3IncidentsLogsAdditionalInfo(BaseModel):
    pass


class V3IncidentsLogsTypedDict(TypedDict):
    r"""Represents a log entry for an incident action."""

    action: str
    time: datetime
    reason: str
    is_manually_created: NotRequired[bool]
    created_by: NotRequired[str]
    updated_by: NotRequired[str]
    assigned_to: NotRequired[str]
    assigned_by: NotRequired[str]
    id: NotRequired[str]
    workflow_id: NotRequired[int]
    additional_info: NotRequired[Nullable[V3IncidentsLogsAdditionalInfoTypedDict]]
    type: NotRequired[str]
    should_show_in_postmortem: NotRequired[bool]


class V3IncidentsLogs(BaseModel):
    r"""Represents a log entry for an incident action."""

    action: str

    time: datetime

    reason: str

    is_manually_created: Optional[bool] = None

    created_by: Optional[str] = None

    updated_by: Optional[str] = None

    assigned_to: Annotated[Optional[str], pydantic.Field(alias="assignedTo")] = None

    assigned_by: Annotated[Optional[str], pydantic.Field(alias="assignedBy")] = None

    id: Optional[str] = None

    workflow_id: Optional[int] = None

    additional_info: Annotated[
        OptionalNullable[V3IncidentsLogsAdditionalInfo],
        pydantic.Field(alias="additionalInfo"),
    ] = UNSET

    type: Optional[str] = None

    should_show_in_postmortem: Optional[bool] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "is_manually_created",
            "created_by",
            "updated_by",
            "assignedTo",
            "assignedBy",
            "id",
            "workflow_id",
            "additionalInfo",
            "type",
            "should_show_in_postmortem",
        ]
        nullable_fields = ["additionalInfo"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
