"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .common_v3_rbacentitypermission import (
    CommonV3RBACEntityPermission,
    CommonV3RBACEntityPermissionTypedDict,
)
from .common_v3_rbacowner import CommonV3RBACOwner, CommonV3RBACOwnerTypedDict
from .v3_incidents_postmortems_postmortemfollowup import (
    V3IncidentsPostmortemsPostmortemFollowUp,
    V3IncidentsPostmortemsPostmortemFollowUpTypedDict,
)
from .v3_incidents_postmortems_postmortemstatus import (
    V3IncidentsPostmortemsPostmortemStatus,
)
from pydantic import model_serializer
from squadcast_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class V3IncidentsPostmortemsPostmortemListResultIncidentTypedDict(TypedDict):
    message: str
    time_of_creation: str


class V3IncidentsPostmortemsPostmortemListResultIncident(BaseModel):
    message: str

    time_of_creation: str


class V3IncidentsPostmortemsPostmortemListResultTypedDict(TypedDict):
    r"""Represents a single result in the postmortem list response."""

    id: str
    organization_id: str
    incident_id: str
    postmortem: str
    follow_ups: Nullable[List[V3IncidentsPostmortemsPostmortemFollowUpTypedDict]]
    created_at: str
    title: str
    status: V3IncidentsPostmortemsPostmortemStatus
    r"""Represents the status of a postmortem."""
    owner: CommonV3RBACOwnerTypedDict
    r"""Represents the RBAC owner of an entity."""
    access_control: List[CommonV3RBACEntityPermissionTypedDict]
    incident_message: str
    incident_time_of_creation: str
    service_name: str
    service_id: str
    alert_source: str
    active_follow_ups_count: int
    attachments: NotRequired[Nullable[List[str]]]
    incident: NotRequired[V3IncidentsPostmortemsPostmortemListResultIncidentTypedDict]


class V3IncidentsPostmortemsPostmortemListResult(BaseModel):
    r"""Represents a single result in the postmortem list response."""

    id: str

    organization_id: str

    incident_id: str

    postmortem: str

    follow_ups: Nullable[List[V3IncidentsPostmortemsPostmortemFollowUp]]

    created_at: str

    title: str

    status: V3IncidentsPostmortemsPostmortemStatus
    r"""Represents the status of a postmortem."""

    owner: CommonV3RBACOwner
    r"""Represents the RBAC owner of an entity."""

    access_control: List[CommonV3RBACEntityPermission]

    incident_message: str

    incident_time_of_creation: str

    service_name: str

    service_id: str

    alert_source: str

    active_follow_ups_count: int

    attachments: OptionalNullable[List[str]] = UNSET

    incident: Optional[V3IncidentsPostmortemsPostmortemListResultIncident] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["attachments", "incident"]
        nullable_fields = ["follow_ups", "attachments"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
