"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .common_v3_rbacentitypermission import (
    CommonV3RBACEntityPermission,
    CommonV3RBACEntityPermissionTypedDict,
)
from .common_v3_rbacowner import CommonV3RBACOwner, CommonV3RBACOwnerTypedDict
from .v3_incidents_tags_additionalresponderdetails import (
    V3IncidentsTagsAdditionalResponderDetails,
    V3IncidentsTagsAdditionalResponderDetailsTypedDict,
)
from .v3_incidents_tags_analytics import (
    V3IncidentsTagsAnalytics,
    V3IncidentsTagsAnalyticsTypedDict,
)
from .v3_incidents_tags_assignedto import (
    V3IncidentsTagsAssignedTo,
    V3IncidentsTagsAssignedToTypedDict,
)
from .v3_incidents_tags_dedupdata import (
    V3IncidentsTagsDedupData,
    V3IncidentsTagsDedupDataTypedDict,
)
from .v3_incidents_tags_incidentpriority import V3IncidentsTagsIncidentPriority
from .v3_incidents_tags_logs import V3IncidentsTagsLogs, V3IncidentsTagsLogsTypedDict
from .v3_incidents_tags_mergeincidententityreference import (
    V3IncidentsTagsMergeIncidentEntityReference,
    V3IncidentsTagsMergeIncidentEntityReferenceTypedDict,
)
from .v3_incidents_tags_notificationdelaypolicy import (
    V3IncidentsTagsNotificationDelayPolicy,
    V3IncidentsTagsNotificationDelayPolicyTypedDict,
)
from .v3_incidents_tags_pinnedmessage import (
    V3IncidentsTagsPinnedMessage,
    V3IncidentsTagsPinnedMessageTypedDict,
)
from .v3_incidents_tags_relevantpeoplelog import (
    V3IncidentsTagsRelevantPeopleLog,
    V3IncidentsTagsRelevantPeopleLogTypedDict,
)
from .v3_incidents_tags_responsenote import (
    V3IncidentsTagsResponseNote,
    V3IncidentsTagsResponseNoteTypedDict,
)
from .v3_incidents_tags_snoozedetails import (
    V3IncidentsTagsSnoozeDetails,
    V3IncidentsTagsSnoozeDetailsTypedDict,
)
from datetime import datetime
import pydantic
from pydantic import model_serializer
from squadcast_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class V3IncidentsTagsIncidentForTagsResponseTagsTypedDict(TypedDict):
    pass


class V3IncidentsTagsIncidentForTagsResponseTags(BaseModel):
    pass


class V3IncidentsTagsIncidentForTagsResponseRetriggerPolicyTypedDict(TypedDict):
    escalation_policy_id: str
    retrigger_at: NotRequired[datetime]
    retriggered_at: NotRequired[datetime]


class V3IncidentsTagsIncidentForTagsResponseRetriggerPolicy(BaseModel):
    escalation_policy_id: Annotated[str, pydantic.Field(alias="escalationPolicyId")]

    retrigger_at: Annotated[Optional[datetime], pydantic.Field(alias="retriggerAt")] = (
        None
    )

    retriggered_at: Annotated[
        Optional[datetime], pydantic.Field(alias="retriggeredAt")
    ] = None


class V3IncidentsTagsIncidentForTagsResponseTypedDict(TypedDict):
    id: str
    service_id: str
    alert_source_id: str
    organization_id: str
    incident_number: int
    message: str
    assigned_to: List[V3IncidentsTagsAssignedToTypedDict]
    additional_responders: List[V3IncidentsTagsAdditionalResponderDetailsTypedDict]
    description: str
    status: str
    time_of_creation: datetime
    updated_at: datetime
    tags: V3IncidentsTagsIncidentForTagsResponseTagsTypedDict
    logs: List[V3IncidentsTagsLogsTypedDict]
    analytics: V3IncidentsTagsAnalyticsTypedDict
    r"""Incident analytics data."""
    pinned_messages: Nullable[List[V3IncidentsTagsPinnedMessageTypedDict]]
    deleted: bool
    event_count: int
    dedup_data: V3IncidentsTagsDedupDataTypedDict
    owner: CommonV3RBACOwnerTypedDict
    r"""Represents the RBAC owner of an entity."""
    access_control: Nullable[List[CommonV3RBACEntityPermissionTypedDict]]
    relevant_users: Nullable[List[str]]
    relevant_escalation_policies: Nullable[List[str]]
    relevant_squads: Nullable[List[str]]
    relevant_schedules: Nullable[List[str]]
    relevant_people_logs: Nullable[List[V3IncidentsTagsRelevantPeopleLogTypedDict]]
    response_notes: Nullable[List[V3IncidentsTagsResponseNoteTypedDict]]
    attachments: Nullable[List[str]]
    is_child: bool
    children: List[V3IncidentsTagsMergeIncidentEntityReferenceTypedDict]
    did_auto_pause: bool
    did_auto_pause_timeout: bool
    auto_pause_ends_at: datetime
    manually_marked_transient_alert_feedback_type: str
    classification_id: int
    grouped_alert_count: int
    has_priority: bool
    snooze_details: V3IncidentsTagsSnoozeDetailsTypedDict
    did_notification_delay: bool
    notification_delay_policy: V3IncidentsTagsNotificationDelayPolicyTypedDict
    r"""Policy for delaying notifications."""
    digest_id: str
    slo_id: NotRequired[int]
    last_acknowledged_at: NotRequired[Nullable[datetime]]
    created_by: NotRequired[str]
    sender_email: NotRequired[str]
    retrigger_policy: NotRequired[
        Nullable[V3IncidentsTagsIncidentForTagsResponseRetriggerPolicyTypedDict]
    ]
    webform_id: NotRequired[int]
    webform_submission_id: NotRequired[int]
    parent: NotRequired[Nullable[V3IncidentsTagsMergeIncidentEntityReferenceTypedDict]]
    priority: NotRequired[V3IncidentsTagsIncidentPriority]
    r"""Represents the priority of an incident."""


class V3IncidentsTagsIncidentForTagsResponse(BaseModel):
    id: str

    service_id: str

    alert_source_id: str

    organization_id: str

    incident_number: Annotated[int, pydantic.Field(alias="incidentNumber")]

    message: str

    assigned_to: Annotated[
        List[V3IncidentsTagsAssignedTo], pydantic.Field(alias="assignedTo")
    ]

    additional_responders: List[V3IncidentsTagsAdditionalResponderDetails]

    description: str

    status: str

    time_of_creation: Annotated[datetime, pydantic.Field(alias="timeOfCreation")]

    updated_at: datetime

    tags: V3IncidentsTagsIncidentForTagsResponseTags

    logs: List[V3IncidentsTagsLogs]

    analytics: V3IncidentsTagsAnalytics
    r"""Incident analytics data."""

    pinned_messages: Nullable[List[V3IncidentsTagsPinnedMessage]]

    deleted: bool

    event_count: int

    dedup_data: V3IncidentsTagsDedupData

    owner: CommonV3RBACOwner
    r"""Represents the RBAC owner of an entity."""

    access_control: Nullable[List[CommonV3RBACEntityPermission]]

    relevant_users: Annotated[
        Nullable[List[str]], pydantic.Field(alias="relevantUsers")
    ]

    relevant_escalation_policies: Annotated[
        Nullable[List[str]], pydantic.Field(alias="relevantEscalationPolicies")
    ]

    relevant_squads: Annotated[
        Nullable[List[str]], pydantic.Field(alias="relevantSquads")
    ]

    relevant_schedules: Annotated[
        Nullable[List[str]], pydantic.Field(alias="relevantSchedules")
    ]

    relevant_people_logs: Annotated[
        Nullable[List[V3IncidentsTagsRelevantPeopleLog]],
        pydantic.Field(alias="relevantPeopleLogs"),
    ]

    response_notes: Annotated[
        Nullable[List[V3IncidentsTagsResponseNote]],
        pydantic.Field(alias="responseNotes"),
    ]

    attachments: Nullable[List[str]]

    is_child: bool

    children: List[V3IncidentsTagsMergeIncidentEntityReference]

    did_auto_pause: bool

    did_auto_pause_timeout: bool

    auto_pause_ends_at: datetime

    manually_marked_transient_alert_feedback_type: str

    classification_id: int

    grouped_alert_count: int

    has_priority: bool

    snooze_details: V3IncidentsTagsSnoozeDetails

    did_notification_delay: bool

    notification_delay_policy: V3IncidentsTagsNotificationDelayPolicy
    r"""Policy for delaying notifications."""

    digest_id: str

    slo_id: Optional[int] = None

    last_acknowledged_at: OptionalNullable[datetime] = UNSET

    created_by: Optional[str] = None

    sender_email: Optional[str] = None

    retrigger_policy: Annotated[
        OptionalNullable[V3IncidentsTagsIncidentForTagsResponseRetriggerPolicy],
        pydantic.Field(alias="retriggerPolicy"),
    ] = UNSET

    webform_id: Optional[int] = None

    webform_submission_id: Optional[int] = None

    parent: OptionalNullable[V3IncidentsTagsMergeIncidentEntityReference] = UNSET

    priority: Optional[V3IncidentsTagsIncidentPriority] = None
    r"""Represents the priority of an incident."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "slo_id",
            "last_acknowledged_at",
            "created_by",
            "sender_email",
            "retriggerPolicy",
            "webform_id",
            "webform_submission_id",
            "parent",
            "priority",
        ]
        nullable_fields = [
            "last_acknowledged_at",
            "pinned_messages",
            "access_control",
            "relevantUsers",
            "relevantEscalationPolicies",
            "relevantSquads",
            "relevantSchedules",
            "relevantPeopleLogs",
            "responseNotes",
            "attachments",
            "retriggerPolicy",
            "parent",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
