"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .common_v3_rbacowner import CommonV3RBACOwner, CommonV3RBACOwnerTypedDict
from .v3_services_aptaconfig import V3ServicesAPTAConfig, V3ServicesAPTAConfigTypedDict
from .v3_services_escalationpolicybasic import (
    V3ServicesEscalationPolicyBasic,
    V3ServicesEscalationPolicyBasicTypedDict,
)
from .v3_services_iagconfig import V3ServicesIAGConfig, V3ServicesIAGConfigTypedDict
from .v3_services_jiracloudextension import (
    V3ServicesJiraCloudExtension,
    V3ServicesJiraCloudExtensionTypedDict,
)
from .v3_services_notificationdelayconfig import (
    V3ServicesNotificationDelayConfig,
    V3ServicesNotificationDelayConfigTypedDict,
)
from .v3_services_servicemaintainer import (
    V3ServicesServiceMaintainer,
    V3ServicesServiceMaintainerTypedDict,
)
from .v3_services_serviceslack import (
    V3ServicesServiceSlack,
    V3ServicesServiceSlackTypedDict,
)
from .v3_services_servicetag import V3ServicesServiceTag, V3ServicesServiceTagTypedDict
from datetime import datetime
from pydantic import model_serializer
from squadcast_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class ConfigTypedDict(TypedDict):
    dedup_key_enabled: bool


class Config(BaseModel):
    dedup_key_enabled: bool


class V3ServicesServiceResponseTypedDict(TypedDict):
    id: str
    name: str
    slug: str
    email: str
    escalation_policy_id: str
    organization_id: str
    api_key: str
    description: str
    owner: CommonV3RBACOwnerTypedDict
    r"""Represents the RBAC owner of an entity."""
    maintainer: V3ServicesServiceMaintainerTypedDict
    tags: List[V3ServicesServiceTagTypedDict]
    auto_pause_transient_alerts_config: V3ServicesAPTAConfigTypedDict
    intelligent_alerts_grouping_config: V3ServicesIAGConfigTypedDict
    delay_notification_config: V3ServicesNotificationDelayConfigTypedDict
    config: ConfigTypedDict
    created_at: datetime
    updated_at: datetime
    depends: NotRequired[Nullable[List[str]]]
    on_maintenance: NotRequired[bool]
    slack: NotRequired[V3ServicesServiceSlackTypedDict]
    escalation_policy: NotRequired[V3ServicesEscalationPolicyBasicTypedDict]
    r"""Represents the basic details of an Escalation Policy for a service."""
    jira_cloud: NotRequired[V3ServicesJiraCloudExtensionTypedDict]


class V3ServicesServiceResponse(BaseModel):
    id: str

    name: str

    slug: str

    email: str

    escalation_policy_id: str

    organization_id: str

    api_key: str

    description: str

    owner: CommonV3RBACOwner
    r"""Represents the RBAC owner of an entity."""

    maintainer: V3ServicesServiceMaintainer

    tags: List[V3ServicesServiceTag]

    auto_pause_transient_alerts_config: V3ServicesAPTAConfig

    intelligent_alerts_grouping_config: V3ServicesIAGConfig

    delay_notification_config: V3ServicesNotificationDelayConfig

    config: Config

    created_at: datetime

    updated_at: datetime

    depends: OptionalNullable[List[str]] = UNSET

    on_maintenance: Optional[bool] = None

    slack: Optional[V3ServicesServiceSlack] = None

    escalation_policy: Optional[V3ServicesEscalationPolicyBasic] = None
    r"""Represents the basic details of an Escalation Policy for a service."""

    jira_cloud: Optional[V3ServicesJiraCloudExtension] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "depends",
            "on_maintenance",
            "slack",
            "escalation_policy",
            "jira_cloud",
        ]
        nullable_fields = ["depends"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
