"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3_slo_sloaction import V3SLOSLOAction, V3SLOSLOActionTypedDict
from .v3_slo_slomonitoringcheck import (
    V3SLOSLOMonitoringCheck,
    V3SLOSLOMonitoringCheckTypedDict,
)
from .v3_slo_sloownertype import V3SLOSLOOwnerType
from .v3_slo_timeintervaltype import V3SLOTimeIntervalType
from datetime import datetime
from pydantic import model_serializer
from squadcast_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class V3SLOSLOResponseTagsTypedDict(TypedDict):
    pass


class V3SLOSLOResponseTags(BaseModel):
    pass


class V3SLOSLOResponseTypedDict(TypedDict):
    id: int
    name: str
    time_interval_type: V3SLOTimeIntervalType
    service_ids: List[str]
    slis: List[str]
    target_slo: float
    start_time: datetime
    end_time: datetime
    allocated_error_budget: float
    is_active: bool
    owner_type: str
    owner_id: str
    org_id: str
    description: NotRequired[str]
    current_slo: NotRequired[float]
    is_healthy: NotRequired[bool]
    remaining_error_budget: NotRequired[float]
    tags: NotRequired[Nullable[V3SLOSLOResponseTagsTypedDict]]
    incident_count: NotRequired[int]
    false_positive_count: NotRequired[int]
    slo_monitoring_checks: NotRequired[List[V3SLOSLOMonitoringCheckTypedDict]]
    slo_actions: NotRequired[Nullable[List[V3SLOSLOActionTypedDict]]]
    slo_owner_id: NotRequired[str]
    slo_owner_type: NotRequired[V3SLOSLOOwnerType]
    created_at: NotRequired[datetime]
    updated_at: NotRequired[datetime]
    deleted_at: NotRequired[Nullable[datetime]]
    duration_in_days: NotRequired[int]


class V3SLOSLOResponse(BaseModel):
    id: int

    name: str

    time_interval_type: V3SLOTimeIntervalType

    service_ids: List[str]

    slis: List[str]

    target_slo: float

    start_time: datetime

    end_time: datetime

    allocated_error_budget: float

    is_active: bool

    owner_type: str

    owner_id: str

    org_id: str

    description: Optional[str] = None

    current_slo: Optional[float] = None

    is_healthy: Optional[bool] = None

    remaining_error_budget: Optional[float] = None

    tags: OptionalNullable[V3SLOSLOResponseTags] = UNSET

    incident_count: Optional[int] = None

    false_positive_count: Optional[int] = None

    slo_monitoring_checks: Optional[List[V3SLOSLOMonitoringCheck]] = None

    slo_actions: OptionalNullable[List[V3SLOSLOAction]] = UNSET

    slo_owner_id: Optional[str] = None

    slo_owner_type: Optional[V3SLOSLOOwnerType] = None

    created_at: Optional[datetime] = None

    updated_at: Optional[datetime] = None

    deleted_at: OptionalNullable[datetime] = UNSET

    duration_in_days: Optional[int] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "current_slo",
            "is_healthy",
            "remaining_error_budget",
            "tags",
            "incident_count",
            "false_positive_count",
            "slo_monitoring_checks",
            "slo_actions",
            "slo_owner_id",
            "slo_owner_type",
            "created_at",
            "updated_at",
            "deleted_at",
            "duration_in_days",
        ]
        nullable_fields = ["tags", "slo_actions", "deleted_at"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
