"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3_users_contact import V3UsersContact, V3UsersContactTypedDict
from .v3_users_notificationrule import (
    V3UsersNotificationRule,
    V3UsersNotificationRuleTypedDict,
)
from pydantic import model_serializer
from squadcast_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class V3UsersUserResponseTypedDict(TypedDict):
    id: str
    first_name: str
    last_name: str
    username_for_display: str
    email: str
    contact: V3UsersContactTypedDict
    secondary_emails: Nullable[List[str]]
    email_verified: bool
    time_zone: str
    title: str
    bio: str
    notification_rules: List[V3UsersNotificationRuleTypedDict]
    user_image: bool
    role_id: NotRequired[str]
    role: NotRequired[str]


class V3UsersUserResponse(BaseModel):
    id: str

    first_name: str

    last_name: str

    username_for_display: str

    email: str

    contact: V3UsersContact

    secondary_emails: Nullable[List[str]]

    email_verified: bool

    time_zone: str

    title: str

    bio: str

    notification_rules: List[V3UsersNotificationRule]

    user_image: bool

    role_id: Optional[str] = None

    role: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["role_id", "role"]
        nullable_fields = ["secondary_emails"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
