"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v3_webforms_recaptchasecrets import (
    V3WebformsRecaptchaSecrets,
    V3WebformsRecaptchaSecretsTypedDict,
)
from .v3_webforms_wfinputfield import (
    V3WebformsWFInputField,
    V3WebformsWFInputFieldTypedDict,
)
from .v3_webforms_wfservice import V3WebformsWFService, V3WebformsWFServiceTypedDict
from squadcast_sdk.types import BaseModel
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class V3WebformsCreateOrUpdateWebformRequestTagsTypedDict(TypedDict):
    r"""Key-value tags for the webform"""


class V3WebformsCreateOrUpdateWebformRequestTags(BaseModel):
    r"""Key-value tags for the webform"""


class V3WebformsCreateOrUpdateWebformRequestTypedDict(TypedDict):
    r"""Public API request for creating a webform"""

    owner_id: str
    r"""Unique identifier of the owner (string or UUID)"""
    name: str
    r"""Name of the webform"""
    is_cname: bool
    r"""Indicates if a custom domain (CNAME) is used"""
    is_captcha_enabled: bool
    r"""Whether CAPTCHA is enabled on the form"""
    captcha_secret: V3WebformsRecaptchaSecretsTypedDict
    r"""CAPTCHA credentials to be validated"""
    form_owner_type: str
    r"""Entity type that owns the form (e.g., team, user)"""
    form_owner_id: str
    r"""Identifier for the owner entity"""
    services: List[V3WebformsWFServiceTypedDict]
    r"""List of services tied to this webform"""
    header: str
    r"""Header text shown on the form"""
    title: str
    r"""Title of the webform"""
    footer_text: str
    r"""Text displayed in the footer"""
    footer_link: str
    r"""Hyperlink in the footer (mailto or https)"""
    host_name: NotRequired[str]
    r"""Custom hostname if CNAME is enabled"""
    tags: NotRequired[V3WebformsCreateOrUpdateWebformRequestTagsTypedDict]
    r"""Key-value tags for the webform"""
    input_field: NotRequired[List[V3WebformsWFInputFieldTypedDict]]
    r"""Input fields to be rendered on the form"""
    logo_url: NotRequired[str]
    r"""URL to the organization's logo"""
    email_on: NotRequired[List[str]]
    r"""Emails to notify on submission"""
    description: NotRequired[str]
    r"""Optional description for the webform"""


class V3WebformsCreateOrUpdateWebformRequest(BaseModel):
    r"""Public API request for creating a webform"""

    owner_id: str
    r"""Unique identifier of the owner (string or UUID)"""

    name: str
    r"""Name of the webform"""

    is_cname: bool
    r"""Indicates if a custom domain (CNAME) is used"""

    is_captcha_enabled: bool
    r"""Whether CAPTCHA is enabled on the form"""

    captcha_secret: V3WebformsRecaptchaSecrets
    r"""CAPTCHA credentials to be validated"""

    form_owner_type: str
    r"""Entity type that owns the form (e.g., team, user)"""

    form_owner_id: str
    r"""Identifier for the owner entity"""

    services: List[V3WebformsWFService]
    r"""List of services tied to this webform"""

    header: str
    r"""Header text shown on the form"""

    title: str
    r"""Title of the webform"""

    footer_text: str
    r"""Text displayed in the footer"""

    footer_link: str
    r"""Hyperlink in the footer (mailto or https)"""

    host_name: Optional[str] = None
    r"""Custom hostname if CNAME is enabled"""

    tags: Optional[V3WebformsCreateOrUpdateWebformRequestTags] = None
    r"""Key-value tags for the webform"""

    input_field: Optional[List[V3WebformsWFInputField]] = None
    r"""Input fields to be rendered on the form"""

    logo_url: Optional[str] = None
    r"""URL to the organization's logo"""

    email_on: Optional[List[str]] = None
    r"""Emails to notify on submission"""

    description: Optional[str] = None
    r"""Optional description for the webform"""
