"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .v4_tag import V4Tag, V4TagTypedDict
import pydantic
from pydantic import model_serializer
from squadcast_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from typing import List, Literal
from typing_extensions import Annotated, TypedDict


V4ScheduleResponseOwnerType = Literal[
    "user",
    "squad",
]


class V4ScheduleResponseTypedDict(TypedDict):
    id: int
    name: str
    description: str
    org_id: str
    team_id: str
    time_zone: str
    paused: bool
    owner_id: str
    owner_type: V4ScheduleResponseOwnerType
    tags: Nullable[List[V4TagTypedDict]]
    created_at: str
    updated_at: str


class V4ScheduleResponse(BaseModel):
    id: int

    name: str

    description: str

    org_id: Annotated[str, pydantic.Field(alias="orgID")]

    team_id: Annotated[str, pydantic.Field(alias="teamID")]

    time_zone: Annotated[str, pydantic.Field(alias="timeZone")]

    paused: bool

    owner_id: Annotated[str, pydantic.Field(alias="ownerID")]

    owner_type: Annotated[
        V4ScheduleResponseOwnerType, pydantic.Field(alias="ownerType")
    ]

    tags: Nullable[List[V4Tag]]

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]

    updated_at: Annotated[str, pydantic.Field(alias="updatedAt")]

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["tags"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
