"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from squadcast_sdk import errors, models, utils
from squadcast_sdk._hooks import HookContext
from squadcast_sdk.types import OptionalNullable, UNSET
from squadcast_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional, Union


class Msteams2(BaseSDK):
    def create_or_update_config(
        self,
        *,
        default_conversation_name: str,
        default_conversation_id: str,
        is_active: bool,
        is_default_active: bool,
        is_custom_channels_active: bool,
        triggers: Union[
            models.V3ExtensionsMSTeamsTriggers,
            models.V3ExtensionsMSTeamsTriggersTypedDict,
        ],
        tenant_id: str,
        from_id: str,
        connected_teams: Union[
            List[models.V3ExtensionsMSTeamsConnectedTeams],
            List[models.V3ExtensionsMSTeamsConnectedTeamsTypedDict],
        ],
        custom_incident_alert_state: Optional[
            Union[
                models.V3ExtensionsMSTeamsIncidentActionAlertState,
                models.V3ExtensionsMSTeamsIncidentActionAlertStateTypedDict,
            ]
        ] = None,
        id: Optional[str] = None,
        organization_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3ExtensionsMSTeamsMSTeamsConfigResponse:
        r"""Create Or Update MSTeams Configuration

        Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header with `user-write` scope.

        :param default_conversation_name: The display name for the default conversation/channel.
        :param default_conversation_id: The unique identifier for the default MS Teams conversation/channel.
        :param is_active: A master switch to enable or disable the entire integration.
        :param is_default_active: Determines if notifications should be sent to the default channel.
        :param is_custom_channels_active: Determines if notifications should be sent to custom-configured channels.
        :param triggers: Configuration for which alerts are sent to the MS Teams channel.
        :param tenant_id: The Azure AD Tenant ID of the organization that owns this extension.
        :param from_id: The Azure AD Object ID of the user who created this extension.
        :param connected_teams: A list of all MS Teams (teams) connected to this organization.
        :param custom_incident_alert_state: A user-friendly way to configure which incident action alerts are active. This is translated by the backend into the 'triggers.custom' array.
        :param id: The MongoDB ObjectID of the extension document. Should be included for updates.
        :param organization_id: The MongoDB ObjectID of the organization this extension belongs to.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3ExtensionsMSTeamsCreateOrUpdateMSTeamsConfigRequest(
            custom_incident_alert_state=utils.get_pydantic_model(
                custom_incident_alert_state,
                Optional[models.V3ExtensionsMSTeamsIncidentActionAlertState],
            ),
            id=id,
            organization_id=organization_id,
            default_conversation_name=default_conversation_name,
            default_conversation_id=default_conversation_id,
            is_active=is_active,
            is_default_active=is_default_active,
            is_custom_channels_active=is_custom_channels_active,
            triggers=utils.get_pydantic_model(
                triggers, models.V3ExtensionsMSTeamsTriggers
            ),
            tenant_id=tenant_id,
            from_id=from_id,
            connected_teams=utils.get_pydantic_model(
                connected_teams, List[models.V3ExtensionsMSTeamsConnectedTeams]
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v3/extensions/msteams/config",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.V3ExtensionsMSTeamsCreateOrUpdateMSTeamsConfigRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="MSTeams_createOrUpdateMsteamsConfiguration",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.MSTeamsCreateOrUpdateMsteamsConfigurationResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def create_or_update_config_async(
        self,
        *,
        default_conversation_name: str,
        default_conversation_id: str,
        is_active: bool,
        is_default_active: bool,
        is_custom_channels_active: bool,
        triggers: Union[
            models.V3ExtensionsMSTeamsTriggers,
            models.V3ExtensionsMSTeamsTriggersTypedDict,
        ],
        tenant_id: str,
        from_id: str,
        connected_teams: Union[
            List[models.V3ExtensionsMSTeamsConnectedTeams],
            List[models.V3ExtensionsMSTeamsConnectedTeamsTypedDict],
        ],
        custom_incident_alert_state: Optional[
            Union[
                models.V3ExtensionsMSTeamsIncidentActionAlertState,
                models.V3ExtensionsMSTeamsIncidentActionAlertStateTypedDict,
            ]
        ] = None,
        id: Optional[str] = None,
        organization_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V3ExtensionsMSTeamsMSTeamsConfigResponse:
        r"""Create Or Update MSTeams Configuration

        Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header with `user-write` scope.

        :param default_conversation_name: The display name for the default conversation/channel.
        :param default_conversation_id: The unique identifier for the default MS Teams conversation/channel.
        :param is_active: A master switch to enable or disable the entire integration.
        :param is_default_active: Determines if notifications should be sent to the default channel.
        :param is_custom_channels_active: Determines if notifications should be sent to custom-configured channels.
        :param triggers: Configuration for which alerts are sent to the MS Teams channel.
        :param tenant_id: The Azure AD Tenant ID of the organization that owns this extension.
        :param from_id: The Azure AD Object ID of the user who created this extension.
        :param connected_teams: A list of all MS Teams (teams) connected to this organization.
        :param custom_incident_alert_state: A user-friendly way to configure which incident action alerts are active. This is translated by the backend into the 'triggers.custom' array.
        :param id: The MongoDB ObjectID of the extension document. Should be included for updates.
        :param organization_id: The MongoDB ObjectID of the organization this extension belongs to.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V3ExtensionsMSTeamsCreateOrUpdateMSTeamsConfigRequest(
            custom_incident_alert_state=utils.get_pydantic_model(
                custom_incident_alert_state,
                Optional[models.V3ExtensionsMSTeamsIncidentActionAlertState],
            ),
            id=id,
            organization_id=organization_id,
            default_conversation_name=default_conversation_name,
            default_conversation_id=default_conversation_id,
            is_active=is_active,
            is_default_active=is_default_active,
            is_custom_channels_active=is_custom_channels_active,
            triggers=utils.get_pydantic_model(
                triggers, models.V3ExtensionsMSTeamsTriggers
            ),
            tenant_id=tenant_id,
            from_id=from_id,
            connected_teams=utils.get_pydantic_model(
                connected_teams, List[models.V3ExtensionsMSTeamsConnectedTeams]
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v3/extensions/msteams/config",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.V3ExtensionsMSTeamsCreateOrUpdateMSTeamsConfigRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="MSTeams_createOrUpdateMsteamsConfiguration",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.MSTeamsCreateOrUpdateMsteamsConfigurationResponse, http_res
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorData, http_res
            )
            raise errors.BadRequestError(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnauthorizedErrorData, http_res
            )
            raise errors.UnauthorizedError(response_data, http_res)
        if utils.match_response(http_res, "402", "application/json"):
            response_data = unmarshal_json_response(
                errors.PaymentRequiredErrorData, http_res
            )
            raise errors.PaymentRequiredError(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.ForbiddenErrorData, http_res)
            raise errors.ForbiddenError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.NotFoundErrorData, http_res)
            raise errors.NotFoundError(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.ConflictErrorData, http_res)
            raise errors.ConflictError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnprocessableEntityErrorData, http_res
            )
            raise errors.UnprocessableEntityError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.InternalServerErrorData, http_res
            )
            raise errors.InternalServerError(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadGatewayErrorData, http_res
            )
            raise errors.BadGatewayError(response_data, http_res)
        if utils.match_response(http_res, "503", "application/json"):
            response_data = unmarshal_json_response(
                errors.ServiceUnavailableErrorData, http_res
            )
            raise errors.ServiceUnavailableError(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(
                errors.GatewayTimeoutErrorData, http_res
            )
            raise errors.GatewayTimeoutError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)
