"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from squadcast_sdk import errors, models, utils
from squadcast_sdk._hooks import HookContext
from squadcast_sdk.types import OptionalNullable, UNSET
from squadcast_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional, Union


class Rotations(BaseSDK):
    def list_by_schedule(
        self,
        *,
        schedule_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.V4RotationResponse]:
        r"""List Schedule Rotations

        :param schedule_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsGetScheduleRotationsRequest(
            schedule_id=schedule_id,
        )

        req = self._build_request(
            method="GET",
            path="/v4/schedules/{scheduleID}/rotations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_getScheduleRotations",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RotationsGetScheduleRotationsResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def list_by_schedule_async(
        self,
        *,
        schedule_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.V4RotationResponse]:
        r"""List Schedule Rotations

        :param schedule_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsGetScheduleRotationsRequest(
            schedule_id=schedule_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v4/schedules/{scheduleID}/rotations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_getScheduleRotations",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RotationsGetScheduleRotationsResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def create(
        self,
        *,
        schedule_id: str,
        name: str,
        start_date: str,
        period: str,
        change_participants_frequency: int,
        change_participants_unit: str,
        participant_groups: Union[
            List[models.V4ParticipantGroup], List[models.V4ParticipantGroupTypedDict]
        ],
        color: Optional[str] = None,
        custom_period_frequency: Optional[int] = None,
        custom_period_unit: Optional[str] = None,
        shift_time_slots: Optional[
            Union[List[models.V4ShiftTimeSlot], List[models.V4ShiftTimeSlotTypedDict]]
        ] = None,
        end_date: Optional[str] = None,
        ends_after_iterations: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4RotationResponse:
        r"""Create Rotation

        :param schedule_id:
        :param name:
        :param start_date:
        :param period:
        :param change_participants_frequency:
        :param change_participants_unit:
        :param participant_groups:
        :param color:
        :param custom_period_frequency:
        :param custom_period_unit:
        :param shift_time_slots:
        :param end_date:
        :param ends_after_iterations:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsCreateRotationRequest(
            schedule_id=schedule_id,
            v4_create_rotation_request=models.V4CreateRotationRequest(
                name=name,
                color=color,
                start_date=start_date,
                period=period,
                custom_period_frequency=custom_period_frequency,
                custom_period_unit=custom_period_unit,
                shift_time_slots=utils.get_pydantic_model(
                    shift_time_slots, Optional[List[models.V4ShiftTimeSlot]]
                ),
                change_participants_frequency=change_participants_frequency,
                change_participants_unit=change_participants_unit,
                end_date=end_date,
                ends_after_iterations=ends_after_iterations,
                participant_groups=utils.get_pydantic_model(
                    participant_groups, List[models.V4ParticipantGroup]
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v4/schedules/{scheduleID}/rotations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_create_rotation_request,
                False,
                False,
                "json",
                models.V4CreateRotationRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_createRotation",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(
                models.RotationsCreateRotationResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        schedule_id: str,
        name: str,
        start_date: str,
        period: str,
        change_participants_frequency: int,
        change_participants_unit: str,
        participant_groups: Union[
            List[models.V4ParticipantGroup], List[models.V4ParticipantGroupTypedDict]
        ],
        color: Optional[str] = None,
        custom_period_frequency: Optional[int] = None,
        custom_period_unit: Optional[str] = None,
        shift_time_slots: Optional[
            Union[List[models.V4ShiftTimeSlot], List[models.V4ShiftTimeSlotTypedDict]]
        ] = None,
        end_date: Optional[str] = None,
        ends_after_iterations: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4RotationResponse:
        r"""Create Rotation

        :param schedule_id:
        :param name:
        :param start_date:
        :param period:
        :param change_participants_frequency:
        :param change_participants_unit:
        :param participant_groups:
        :param color:
        :param custom_period_frequency:
        :param custom_period_unit:
        :param shift_time_slots:
        :param end_date:
        :param ends_after_iterations:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsCreateRotationRequest(
            schedule_id=schedule_id,
            v4_create_rotation_request=models.V4CreateRotationRequest(
                name=name,
                color=color,
                start_date=start_date,
                period=period,
                custom_period_frequency=custom_period_frequency,
                custom_period_unit=custom_period_unit,
                shift_time_slots=utils.get_pydantic_model(
                    shift_time_slots, Optional[List[models.V4ShiftTimeSlot]]
                ),
                change_participants_frequency=change_participants_frequency,
                change_participants_unit=change_participants_unit,
                end_date=end_date,
                ends_after_iterations=ends_after_iterations,
                participant_groups=utils.get_pydantic_model(
                    participant_groups, List[models.V4ParticipantGroup]
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v4/schedules/{scheduleID}/rotations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_create_rotation_request,
                False,
                False,
                "json",
                models.V4CreateRotationRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_createRotation",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(
                models.RotationsCreateRotationResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def delete(
        self,
        *,
        schedule_id: str,
        rotation_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> bytes:
        r"""Delete Rotation

        :param schedule_id:
        :param rotation_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsDeleteRotationRequest(
            schedule_id=schedule_id,
            rotation_id=rotation_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/v4/schedules/{scheduleID}/rotations/{rotationID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="*/*",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_deleteRotation",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*/*"):
            http_res_bytes = utils.stream_to_bytes(http_res)
            return http_res_bytes
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def delete_async(
        self,
        *,
        schedule_id: str,
        rotation_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> bytes:
        r"""Delete Rotation

        :param schedule_id:
        :param rotation_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsDeleteRotationRequest(
            schedule_id=schedule_id,
            rotation_id=rotation_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/v4/schedules/{scheduleID}/rotations/{rotationID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="*/*",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_deleteRotation",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*/*"):
            http_res_bytes = await utils.stream_to_bytes_async(http_res)
            return http_res_bytes
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def get_by_id(
        self,
        *,
        schedule_id: str,
        rotation_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4RotationResponse:
        r"""Get Schedule Rotation by ID

        :param schedule_id:
        :param rotation_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsGetScheduleRotationByIDRequest(
            schedule_id=schedule_id,
            rotation_id=rotation_id,
        )

        req = self._build_request(
            method="GET",
            path="/v4/schedules/{scheduleID}/rotations/{rotationID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_getScheduleRotationById",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RotationsGetScheduleRotationByIDResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def get_by_id_async(
        self,
        *,
        schedule_id: str,
        rotation_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4RotationResponse:
        r"""Get Schedule Rotation by ID

        :param schedule_id:
        :param rotation_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsGetScheduleRotationByIDRequest(
            schedule_id=schedule_id,
            rotation_id=rotation_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v4/schedules/{scheduleID}/rotations/{rotationID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_getScheduleRotationById",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RotationsGetScheduleRotationByIDResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def update(
        self,
        *,
        schedule_id: str,
        rotation_id: str,
        name: str,
        start_date: str,
        period: str,
        change_participants_frequency: int,
        change_participants_unit: str,
        color: Optional[str] = None,
        custom_period_frequency: Optional[int] = None,
        custom_period_unit: Optional[str] = None,
        shift_time_slots: Optional[
            Union[List[models.V4ShiftTimeSlot], List[models.V4ShiftTimeSlotTypedDict]]
        ] = None,
        end_date: Optional[str] = None,
        ends_after_iterations: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4RotationResponse:
        r"""Update Rotation

        :param schedule_id:
        :param rotation_id:
        :param name:
        :param start_date:
        :param period:
        :param change_participants_frequency:
        :param change_participants_unit:
        :param color:
        :param custom_period_frequency:
        :param custom_period_unit:
        :param shift_time_slots:
        :param end_date:
        :param ends_after_iterations:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsUpdateRotationRequest(
            schedule_id=schedule_id,
            rotation_id=rotation_id,
            v4_update_rotation_request=models.V4UpdateRotationRequest(
                name=name,
                color=color,
                start_date=start_date,
                period=period,
                custom_period_frequency=custom_period_frequency,
                custom_period_unit=custom_period_unit,
                shift_time_slots=utils.get_pydantic_model(
                    shift_time_slots, Optional[List[models.V4ShiftTimeSlot]]
                ),
                change_participants_frequency=change_participants_frequency,
                change_participants_unit=change_participants_unit,
                end_date=end_date,
                ends_after_iterations=ends_after_iterations,
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/v4/schedules/{scheduleID}/rotations/{rotationID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_update_rotation_request,
                False,
                False,
                "json",
                models.V4UpdateRotationRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_updateRotation",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RotationsUpdateRotationResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def update_async(
        self,
        *,
        schedule_id: str,
        rotation_id: str,
        name: str,
        start_date: str,
        period: str,
        change_participants_frequency: int,
        change_participants_unit: str,
        color: Optional[str] = None,
        custom_period_frequency: Optional[int] = None,
        custom_period_unit: Optional[str] = None,
        shift_time_slots: Optional[
            Union[List[models.V4ShiftTimeSlot], List[models.V4ShiftTimeSlotTypedDict]]
        ] = None,
        end_date: Optional[str] = None,
        ends_after_iterations: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4RotationResponse:
        r"""Update Rotation

        :param schedule_id:
        :param rotation_id:
        :param name:
        :param start_date:
        :param period:
        :param change_participants_frequency:
        :param change_participants_unit:
        :param color:
        :param custom_period_frequency:
        :param custom_period_unit:
        :param shift_time_slots:
        :param end_date:
        :param ends_after_iterations:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsUpdateRotationRequest(
            schedule_id=schedule_id,
            rotation_id=rotation_id,
            v4_update_rotation_request=models.V4UpdateRotationRequest(
                name=name,
                color=color,
                start_date=start_date,
                period=period,
                custom_period_frequency=custom_period_frequency,
                custom_period_unit=custom_period_unit,
                shift_time_slots=utils.get_pydantic_model(
                    shift_time_slots, Optional[List[models.V4ShiftTimeSlot]]
                ),
                change_participants_frequency=change_participants_frequency,
                change_participants_unit=change_participants_unit,
                end_date=end_date,
                ends_after_iterations=ends_after_iterations,
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/v4/schedules/{scheduleID}/rotations/{rotationID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_update_rotation_request,
                False,
                False,
                "json",
                models.V4UpdateRotationRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_updateRotation",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RotationsUpdateRotationResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def get_participants(
        self,
        *,
        schedule_id: str,
        rotation_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4GetRotationParticipantsResponse:
        r"""Get Rotation Participants

        :param schedule_id:
        :param rotation_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsGetRotationParticipantsRequest(
            schedule_id=schedule_id,
            rotation_id=rotation_id,
        )

        req = self._build_request(
            method="GET",
            path="/v4/schedules/{scheduleID}/rotations/{rotationID}/participants",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_getRotationParticipants",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RotationsGetRotationParticipantsResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def get_participants_async(
        self,
        *,
        schedule_id: str,
        rotation_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4GetRotationParticipantsResponse:
        r"""Get Rotation Participants

        :param schedule_id:
        :param rotation_id:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsGetRotationParticipantsRequest(
            schedule_id=schedule_id,
            rotation_id=rotation_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/v4/schedules/{scheduleID}/rotations/{rotationID}/participants",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_getRotationParticipants",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RotationsGetRotationParticipantsResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def update_participants(
        self,
        *,
        schedule_id: str,
        rotation_id: str,
        participant_groups: Union[
            List[models.V4ParticipantGroup], List[models.V4ParticipantGroupTypedDict]
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4RotationParticipantsResponse:
        r"""Update Rotation Participants

        :param schedule_id:
        :param rotation_id:
        :param participant_groups:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsUpdateRotationParticipantsRequest(
            schedule_id=schedule_id,
            rotation_id=rotation_id,
            v4_update_rotation_participants_request=models.V4UpdateRotationParticipantsRequest(
                participant_groups=utils.get_pydantic_model(
                    participant_groups, List[models.V4ParticipantGroup]
                ),
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/v4/schedules/{scheduleID}/rotations/{rotationID}/participants",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_update_rotation_participants_request,
                False,
                False,
                "json",
                models.V4UpdateRotationParticipantsRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_updateRotationParticipants",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RotationsUpdateRotationParticipantsResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def update_participants_async(
        self,
        *,
        schedule_id: str,
        rotation_id: str,
        participant_groups: Union[
            List[models.V4ParticipantGroup], List[models.V4ParticipantGroupTypedDict]
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4RotationParticipantsResponse:
        r"""Update Rotation Participants

        :param schedule_id:
        :param rotation_id:
        :param participant_groups:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.RotationsUpdateRotationParticipantsRequest(
            schedule_id=schedule_id,
            rotation_id=rotation_id,
            v4_update_rotation_participants_request=models.V4UpdateRotationParticipantsRequest(
                participant_groups=utils.get_pydantic_model(
                    participant_groups, List[models.V4ParticipantGroup]
                ),
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/v4/schedules/{scheduleID}/rotations/{rotationID}/participants",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_update_rotation_participants_request,
                False,
                False,
                "json",
                models.V4UpdateRotationParticipantsRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Rotations_updateRotationParticipants",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.RotationsUpdateRotationParticipantsResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)
