"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from squadcast_sdk import errors, models, utils
from squadcast_sdk._hooks import HookContext
from squadcast_sdk.types import OptionalNullable, UNSET
from squadcast_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional, Union


class SchedulesOverrides(BaseSDK):
    def list(
        self,
        *,
        schedule_id: str,
        start_time: str,
        end_time: str,
        participant_id: Optional[str] = None,
        page_size: Optional[int] = None,
        cursor: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.V4OverrideResponse]:
        r"""List Overrides

        :param schedule_id:
        :param start_time:
        :param end_time:
        :param participant_id:
        :param page_size:
        :param cursor:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OverridesListOverridesRequest(
            schedule_id=schedule_id,
            start_time=start_time,
            end_time=end_time,
            participant_id=participant_id,
            page_size=page_size,
            cursor=cursor,
        )

        req = self._build_request(
            method="GET",
            path="/v4/schedules/{scheduleID}/overrides",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Overrides_listOverrides",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.OverridesListOverridesResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        schedule_id: str,
        start_time: str,
        end_time: str,
        participant_id: Optional[str] = None,
        page_size: Optional[int] = None,
        cursor: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> List[models.V4OverrideResponse]:
        r"""List Overrides

        :param schedule_id:
        :param start_time:
        :param end_time:
        :param participant_id:
        :param page_size:
        :param cursor:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OverridesListOverridesRequest(
            schedule_id=schedule_id,
            start_time=start_time,
            end_time=end_time,
            participant_id=participant_id,
            page_size=page_size,
            cursor=cursor,
        )

        req = self._build_request_async(
            method="GET",
            path="/v4/schedules/{scheduleID}/overrides",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Overrides_listOverrides",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.OverridesListOverridesResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def create(
        self,
        *,
        schedule_id: str,
        start_time: str,
        end_time: str,
        reason: str,
        overridden_participant: Union[
            models.V4OverrideParticipantGroup,
            models.V4OverrideParticipantGroupTypedDict,
        ],
        override_with: Union[
            models.V4OverrideParticipantGroup,
            models.V4OverrideParticipantGroupTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4OverrideResponse:
        r"""Create Schedule Override

        :param schedule_id:
        :param start_time:
        :param end_time:
        :param reason:
        :param overridden_participant:
        :param override_with:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OverridesCreateScheduleOverrideRequest(
            schedule_id=schedule_id,
            v4_create_schedule_override_request=models.V4CreateScheduleOverrideRequest(
                start_time=start_time,
                end_time=end_time,
                reason=reason,
                overridden_participant=utils.get_pydantic_model(
                    overridden_participant, models.V4OverrideParticipantGroup
                ),
                override_with=utils.get_pydantic_model(
                    override_with, models.V4OverrideParticipantGroup
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/v4/schedules/{scheduleID}/overrides",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_create_schedule_override_request,
                False,
                False,
                "json",
                models.V4CreateScheduleOverrideRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Overrides_createScheduleOverride",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(
                models.OverridesCreateScheduleOverrideResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        schedule_id: str,
        start_time: str,
        end_time: str,
        reason: str,
        overridden_participant: Union[
            models.V4OverrideParticipantGroup,
            models.V4OverrideParticipantGroupTypedDict,
        ],
        override_with: Union[
            models.V4OverrideParticipantGroup,
            models.V4OverrideParticipantGroupTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4OverrideResponse:
        r"""Create Schedule Override

        :param schedule_id:
        :param start_time:
        :param end_time:
        :param reason:
        :param overridden_participant:
        :param override_with:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OverridesCreateScheduleOverrideRequest(
            schedule_id=schedule_id,
            v4_create_schedule_override_request=models.V4CreateScheduleOverrideRequest(
                start_time=start_time,
                end_time=end_time,
                reason=reason,
                overridden_participant=utils.get_pydantic_model(
                    overridden_participant, models.V4OverrideParticipantGroup
                ),
                override_with=utils.get_pydantic_model(
                    override_with, models.V4OverrideParticipantGroup
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/v4/schedules/{scheduleID}/overrides",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_create_schedule_override_request,
                False,
                False,
                "json",
                models.V4CreateScheduleOverrideRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Overrides_createScheduleOverride",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(
                models.OverridesCreateScheduleOverrideResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def update(
        self,
        *,
        schedule_id: str,
        override_id: str,
        start_time: str,
        end_time: str,
        reason: str,
        overridden_participant: Union[
            models.V4OverrideParticipantGroup,
            models.V4OverrideParticipantGroupTypedDict,
        ],
        override_with: Union[
            models.V4OverrideParticipantGroup,
            models.V4OverrideParticipantGroupTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4OverrideResponse:
        r"""Update Schedule Override

        :param schedule_id:
        :param override_id:
        :param start_time:
        :param end_time:
        :param reason:
        :param overridden_participant:
        :param override_with:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OverridesUpdateScheduleOverrideRequest(
            schedule_id=schedule_id,
            override_id=override_id,
            v4_update_schedule_override_request=models.V4UpdateScheduleOverrideRequest(
                start_time=start_time,
                end_time=end_time,
                reason=reason,
                overridden_participant=utils.get_pydantic_model(
                    overridden_participant, models.V4OverrideParticipantGroup
                ),
                override_with=utils.get_pydantic_model(
                    override_with, models.V4OverrideParticipantGroup
                ),
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/v4/schedules/{scheduleID}/overrides/{overrideID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_update_schedule_override_request,
                False,
                False,
                "json",
                models.V4UpdateScheduleOverrideRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Overrides_updateScheduleOverride",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.OverridesUpdateScheduleOverrideResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def update_async(
        self,
        *,
        schedule_id: str,
        override_id: str,
        start_time: str,
        end_time: str,
        reason: str,
        overridden_participant: Union[
            models.V4OverrideParticipantGroup,
            models.V4OverrideParticipantGroupTypedDict,
        ],
        override_with: Union[
            models.V4OverrideParticipantGroup,
            models.V4OverrideParticipantGroupTypedDict,
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4OverrideResponse:
        r"""Update Schedule Override

        :param schedule_id:
        :param override_id:
        :param start_time:
        :param end_time:
        :param reason:
        :param overridden_participant:
        :param override_with:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.OverridesUpdateScheduleOverrideRequest(
            schedule_id=schedule_id,
            override_id=override_id,
            v4_update_schedule_override_request=models.V4UpdateScheduleOverrideRequest(
                start_time=start_time,
                end_time=end_time,
                reason=reason,
                overridden_participant=utils.get_pydantic_model(
                    overridden_participant, models.V4OverrideParticipantGroup
                ),
                override_with=utils.get_pydantic_model(
                    override_with, models.V4OverrideParticipantGroup
                ),
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/v4/schedules/{scheduleID}/overrides/{overrideID}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_update_schedule_override_request,
                False,
                False,
                "json",
                models.V4UpdateScheduleOverrideRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Overrides_updateScheduleOverride",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.OverridesUpdateScheduleOverrideResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)
