"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from squadcast_sdk import errors, models, utils
from squadcast_sdk._hooks import HookContext
from squadcast_sdk.types import OptionalNullable, UNSET
from squadcast_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, List, Mapping, Optional, Union


class SquadsV4(BaseSDK):
    def create(
        self,
        *,
        owner_id: str,
        name: str,
        members: Union[
            List[models.V4SquadsSquadMember], List[models.V4SquadsSquadMemberTypedDict]
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4SquadsCreateSquadResponse:
        r"""Create Squad

        This endpoint is used to create a new squad.
        The role will be considered only if your organization is on the OBAC permission model; otherwise, the role field will be ignored, and only the member will be added to the squad.

        Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header with `squad-create` scope.

        :param owner_id:
        :param name:
        :param members:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V4SquadsCreateSquadRequest(
            owner_id=owner_id,
            name=name,
            members=utils.get_pydantic_model(members, List[models.V4SquadsSquadMember]),
        )

        req = self._build_request(
            method="POST",
            path="/v4/squads",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.V4SquadsCreateSquadRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Squads_createSquad",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.SquadsCreateSquadResponse, http_res)
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        owner_id: str,
        name: str,
        members: Union[
            List[models.V4SquadsSquadMember], List[models.V4SquadsSquadMemberTypedDict]
        ],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4SquadsCreateSquadResponse:
        r"""Create Squad

        This endpoint is used to create a new squad.
        The role will be considered only if your organization is on the OBAC permission model; otherwise, the role field will be ignored, and only the member will be added to the squad.

        Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header with `squad-create` scope.

        :param owner_id:
        :param name:
        :param members:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V4SquadsCreateSquadRequest(
            owner_id=owner_id,
            name=name,
            members=utils.get_pydantic_model(members, List[models.V4SquadsSquadMember]),
        )

        req = self._build_request_async(
            method="POST",
            path="/v4/squads",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.V4SquadsCreateSquadRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Squads_createSquad",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.SquadsCreateSquadResponse, http_res)
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    def update_name(
        self,
        *,
        squad_id: str,
        name: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4SquadsUpdateSquadNameResponse:
        r"""Update Squad Name

        This endpoint is used to update squad's name.
        Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header with `squad-create` scope.

        :param squad_id:
        :param name:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SquadsUpdateSquadNameRequest(
            squad_id=squad_id,
            v4_squads_update_squad_name_request=models.V4SquadsUpdateSquadNameRequest(
                name=name,
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/v4/squads/{squadID}/name",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_squads_update_squad_name_request,
                False,
                False,
                "json",
                models.V4SquadsUpdateSquadNameRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Squads_updateSquadName",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.SquadsUpdateSquadNameResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)

    async def update_name_async(
        self,
        *,
        squad_id: str,
        name: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V4SquadsUpdateSquadNameResponse:
        r"""Update Squad Name

        This endpoint is used to update squad's name.
        Requires `access_token` as a `Bearer {{token}}` in the `Authorization` header with `squad-create` scope.

        :param squad_id:
        :param name:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SquadsUpdateSquadNameRequest(
            squad_id=squad_id,
            v4_squads_update_squad_name_request=models.V4SquadsUpdateSquadNameRequest(
                name=name,
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/v4/squads/{squadID}/name",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.v4_squads_update_squad_name_request,
                False,
                False,
                "json",
                models.V4SquadsUpdateSquadNameRequest,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Squads_updateSquadName",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "402",
                "403",
                "404",
                "409",
                "422",
                "4XX",
                "500",
                "502",
                "503",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.SquadsUpdateSquadNameResponse, http_res
            )
        if utils.match_response(
            http_res,
            ["400", "401", "402", "403", "404", "409", "422"],
            "application/json",
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(
            http_res, ["500", "502", "503", "504"], "application/json"
        ):
            response_data = unmarshal_json_response(errors.CommonV4ErrorData, http_res)
            raise errors.CommonV4Error(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.SDKDefaultError("API error occurred", http_res, http_res_text)

        raise errors.SDKDefaultError("Unexpected response received", http_res)
