"""TaskTypeAssetTypeLink/DepartmentMetadataDescriptorLink add index, pkey and constraint

Revision ID: 20a8ad264659
Revises: 539a3a00c417
Create Date: 2025-01-26 23:15:27.665887

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "20a8ad264659"
down_revision = "539a3a00c417"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "department_metadata_descriptor_link", schema=None
    ) as batch_op:
        batch_op.alter_column(
            "metadata_descriptor_id", existing_type=sa.UUID(), nullable=False
        )
        batch_op.alter_column(
            "department_id", existing_type=sa.UUID(), nullable=False
        )
        batch_op.create_unique_constraint(
            "department_metadata_descriptor_link_uc",
            ["metadata_descriptor_id", "department_id"],
        )
        batch_op.create_index(
            batch_op.f("ix_department_metadata_descriptor_link_department_id"),
            ["department_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f(
                "ix_department_metadata_descriptor_link_metadata_descriptor_id"
            ),
            ["metadata_descriptor_id"],
            unique=False,
        )

        batch_op.create_primary_key(
            "department_metadata_descriptor_link_pkey",
            ["metadata_descriptor_id", "department_id"],
        )

    with op.batch_alter_table(
        "task_type_asset_type_link", schema=None
    ) as batch_op:
        batch_op.alter_column(
            "asset_type_id", existing_type=sa.UUID(), nullable=False
        )
        batch_op.alter_column(
            "task_type_id", existing_type=sa.UUID(), nullable=False
        )
        batch_op.create_index(
            batch_op.f("ix_task_type_asset_type_link_asset_type_id"),
            ["asset_type_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_task_type_asset_type_link_task_type_id"),
            ["task_type_id"],
            unique=False,
        )
        batch_op.create_unique_constraint(
            "task_type_asset_type_link_uc", ["asset_type_id", "task_type_id"]
        )

        batch_op.create_primary_key(
            "task_type_asset_type_link_pkey", ["asset_type_id", "task_type_id"]
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "task_type_asset_type_link", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            "task_type_asset_type_link_pkey", type_="primary"
        )
        batch_op.drop_constraint(
            "task_type_asset_type_link_uc", type_="unique"
        )
        batch_op.drop_index(
            batch_op.f("ix_task_type_asset_type_link_task_type_id")
        )
        batch_op.drop_index(
            batch_op.f("ix_task_type_asset_type_link_asset_type_id")
        )

        batch_op.alter_column(
            "task_type_id", existing_type=sa.UUID(), nullable=True
        )
        batch_op.alter_column(
            "asset_type_id", existing_type=sa.UUID(), nullable=True
        )

    with op.batch_alter_table(
        "department_metadata_descriptor_link", schema=None
    ) as batch_op:
        batch_op.drop_index(
            batch_op.f(
                "ix_department_metadata_descriptor_link_metadata_descriptor_id"
            )
        )
        batch_op.drop_index(
            batch_op.f("ix_department_metadata_descriptor_link_department_id")
        )
        batch_op.drop_constraint(
            "department_metadata_descriptor_link_pkey", type_="primary"
        )
        batch_op.drop_constraint(
            "department_metadata_descriptor_link_uc", type_="unique"
        )
        batch_op.alter_column(
            "department_id", existing_type=sa.UUID(), nullable=True
        )
        batch_op.alter_column(
            "metadata_descriptor_id", existing_type=sa.UUID(), nullable=True
        )

    # ### end Alembic commands ###
