"""add fields to the software table

Revision ID: 4bd9bfb73f11
Revises: 4d585b6956f2
Create Date: 2025-07-14 12:07:08.700862

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "4bd9bfb73f11"
down_revision = "4d585b6956f2"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("salary_scale", schema=None) as batch_op:
        batch_op.alter_column(
            "salary", existing_type=sa.INTEGER(), nullable=False
        )

    with op.batch_alter_table("software", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("monthly_cost", sa.Integer(), nullable=True)
        )
        batch_op.add_column(
            sa.Column("inventory_amount", sa.Integer(), nullable=True)
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("software", schema=None) as batch_op:
        batch_op.drop_column("inventory_amount")
        batch_op.drop_column("monthly_cost")

    with op.batch_alter_table("salary_scale", schema=None) as batch_op:
        batch_op.alter_column(
            "salary", existing_type=sa.INTEGER(), nullable=True
        )

    # ### end Alembic commands ###
