"""modify salary scale model

Revision ID: d25118cddcaa
Revises: 7a16258f2fab
Create Date: 2025-04-23 22:49:26.645851

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils


# revision identifiers, used by Alembic.
revision = "d25118cddcaa"
down_revision = "7a16258f2fab"
branch_labels = None
depends_on = None

from zou.app.models.person import POSITION_TYPES, SENIORITY_TYPES


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("salary_scale", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "position",
                sqlalchemy_utils.types.choice.ChoiceType(POSITION_TYPES),
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "seniority",
                sqlalchemy_utils.types.choice.ChoiceType(SENIORITY_TYPES),
                nullable=False,
            )
        )
        batch_op.add_column(sa.Column("salary", sa.Integer(), nullable=False))
        batch_op.drop_column("mid_artist_salary")
        batch_op.drop_column("junior_lead_salary")
        batch_op.drop_column("mid_lead_salary")
        batch_op.drop_column("mid_supervisor_salary")
        batch_op.drop_column("junior_supervisor_salary")
        batch_op.drop_column("senior_artist_salary")
        batch_op.drop_column("senior_lead_salary")
        batch_op.drop_column("junior_artist_salary")
        batch_op.drop_column("senior_supervisor_salary")

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("salary_scale", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "senior_supervisor_salary",
                sa.INTEGER(),
                autoincrement=False,
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "junior_artist_salary",
                sa.INTEGER(),
                autoincrement=False,
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "senior_lead_salary",
                sa.INTEGER(),
                autoincrement=False,
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "senior_artist_salary",
                sa.INTEGER(),
                autoincrement=False,
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "junior_supervisor_salary",
                sa.INTEGER(),
                autoincrement=False,
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "mid_supervisor_salary",
                sa.INTEGER(),
                autoincrement=False,
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "mid_lead_salary",
                sa.INTEGER(),
                autoincrement=False,
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "junior_lead_salary",
                sa.INTEGER(),
                autoincrement=False,
                nullable=False,
            )
        )
        batch_op.add_column(
            sa.Column(
                "mid_artist_salary",
                sa.INTEGER(),
                autoincrement=False,
                nullable=False,
            )
        )
        batch_op.drop_column("salary")
        batch_op.drop_column("seniority")
        batch_op.drop_column("position")

    # ### end Alembic commands ###
