"""Add ProductionScheduleVersionTaskLinkPersonLink

Revision ID: d97f2730bf7b
Revises: 5f715f2b6348
Create Date: 2025-07-16 02:07:13.855652

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "d97f2730bf7b"
down_revision = "5f715f2b6348"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.rename_table("assignations", "task_person_link")
    with op.batch_alter_table(
        "production_schedule_version_task_link", schema=None
    ) as batch_op:
        batch_op.alter_column(
            "production_schedule_version_id",
            existing_type=sa.UUID(),
            nullable=True,
        )
        batch_op.alter_column(
            "task_id", existing_type=sa.UUID(), nullable=True
        )
        batch_op.create_index(
            batch_op.f(
                "ix_production_schedule_version_task_link_production_schedule_version_id"
            ),
            ["production_schedule_version_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_production_schedule_version_task_link_task_id"),
            ["task_id"],
            unique=False,
        )
    op.create_table(
        "production_schedule_version_task_link_person_link",
        sa.Column(
            "production_schedule_version_task_link_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column(
            "person_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["person_id"],
            ["person.id"],
        ),
        sa.ForeignKeyConstraint(
            ["production_schedule_version_task_link_id"],
            ["production_schedule_version_task_link.id"],
        ),
        sa.PrimaryKeyConstraint(
            "production_schedule_version_task_link_id", "person_id"
        ),
    )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("production_schedule_version_task_link_person_link")
    with op.batch_alter_table(
        "production_schedule_version_task_link", schema=None
    ) as batch_op:
        batch_op.drop_index(
            batch_op.f("ix_production_schedule_version_task_link_task_id")
        )
        batch_op.drop_index(
            batch_op.f(
                "ix_production_schedule_version_task_link_production_schedule_version_id"
            )
        )
        batch_op.alter_column(
            "task_id", existing_type=sa.UUID(), nullable=False
        )
        batch_op.alter_column(
            "production_schedule_version_id",
            existing_type=sa.UUID(),
            nullable=False,
        )
    op.rename_table("task_person_link", "assignations")
    # ### end Alembic commands ###
