"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .sdkconfiguration import SDKConfiguration
from gr4vy import errors, models, utils
from gr4vy._hooks import HookContext
from gr4vy.buyers_gift_cards import BuyersGiftCards
from gr4vy.buyers_payment_methods import BuyersPaymentMethods
from gr4vy.buyers_shipping_details import BuyersShippingDetails
from gr4vy.types import OptionalNullable, UNSET
from gr4vy.utils import get_security_from_env
from gr4vy.utils.unmarshal_json_response import unmarshal_json_response
from jsonpath import JSONPath
from typing import Any, Dict, List, Mapping, Optional, Union


class BuyersSDK(BaseSDK):
    payment_methods: BuyersPaymentMethods
    gift_cards: BuyersGiftCards
    shipping_details: BuyersShippingDetails

    def __init__(
        self, sdk_config: SDKConfiguration, parent_ref: Optional[object] = None
    ) -> None:
        BaseSDK.__init__(self, sdk_config, parent_ref=parent_ref)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    def _init_sdks(self):
        self.payment_methods = BuyersPaymentMethods(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.gift_cards = BuyersGiftCards(
            self.sdk_configuration, parent_ref=self.parent_ref
        )
        self.shipping_details = BuyersShippingDetails(
            self.sdk_configuration, parent_ref=self.parent_ref
        )

    def list(
        self,
        *,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        search: OptionalNullable[str] = UNSET,
        external_identifier: OptionalNullable[str] = UNSET,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListBuyersResponse]:
        r"""List all buyers

        List all buyers or search for a specific buyer.

        :param cursor: A pointer to the page of results to return.
        :param limit: The maximum number of items that are at returned.
        :param search: Filters the results to only the buyers for which the `display_name` or `external_identifier` matches this value.
        :param external_identifier: Filters the results to only the buyers for which the `external_identifier` matches this value.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListBuyersRequest(
            cursor=cursor,
            limit=limit,
            search=search,
            external_identifier=external_identifier,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request(
            method="GET",
            path="/buyers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.ListBuyersGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_buyers",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListBuyersResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list(
                cursor=next_cursor,
                limit=limit,
                search=search,
                external_identifier=external_identifier,
                merchant_account_id=merchant_account_id,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.ListBuyersResponse(
                result=unmarshal_json_response(models.Buyers, http_res), next=next_func
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.Error400Data, http_res)
            raise errors.Error400(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.Error401Data, http_res)
            raise errors.Error401(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.Error403Data, http_res)
            raise errors.Error403(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.Error404Data, http_res)
            raise errors.Error404(response_data, http_res)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = unmarshal_json_response(errors.Error405Data, http_res)
            raise errors.Error405(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.Error409Data, http_res)
            raise errors.Error409(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = unmarshal_json_response(errors.Error425Data, http_res)
            raise errors.Error425(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(errors.Error429Data, http_res)
            raise errors.Error429(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.Error500Data, http_res)
            raise errors.Error500(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(errors.Error502Data, http_res)
            raise errors.Error502(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(errors.Error504Data, http_res)
            raise errors.Error504(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        cursor: OptionalNullable[str] = UNSET,
        limit: Optional[int] = 20,
        search: OptionalNullable[str] = UNSET,
        external_identifier: OptionalNullable[str] = UNSET,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.ListBuyersResponse]:
        r"""List all buyers

        List all buyers or search for a specific buyer.

        :param cursor: A pointer to the page of results to return.
        :param limit: The maximum number of items that are at returned.
        :param search: Filters the results to only the buyers for which the `display_name` or `external_identifier` matches this value.
        :param external_identifier: Filters the results to only the buyers for which the `external_identifier` matches this value.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ListBuyersRequest(
            cursor=cursor,
            limit=limit,
            search=search,
            external_identifier=external_identifier,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/buyers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.ListBuyersGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="list_buyers",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.ListBuyersResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])
            next_cursor = JSONPath("$.next_cursor").parse(body)

            if len(next_cursor) == 0:
                return None

            next_cursor = next_cursor[0]
            if next_cursor is None or str(next_cursor).strip() == "":
                return None

            return self.list(
                cursor=next_cursor,
                limit=limit,
                search=search,
                external_identifier=external_identifier,
                merchant_account_id=merchant_account_id,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.ListBuyersResponse(
                result=unmarshal_json_response(models.Buyers, http_res), next=next_func
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.Error400Data, http_res)
            raise errors.Error400(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.Error401Data, http_res)
            raise errors.Error401(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.Error403Data, http_res)
            raise errors.Error403(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.Error404Data, http_res)
            raise errors.Error404(response_data, http_res)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = unmarshal_json_response(errors.Error405Data, http_res)
            raise errors.Error405(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.Error409Data, http_res)
            raise errors.Error409(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = unmarshal_json_response(errors.Error425Data, http_res)
            raise errors.Error425(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(errors.Error429Data, http_res)
            raise errors.Error429(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.Error500Data, http_res)
            raise errors.Error500(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(errors.Error502Data, http_res)
            raise errors.Error502(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(errors.Error504Data, http_res)
            raise errors.Error504(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def create(
        self,
        *,
        merchant_account_id: Optional[str] = None,
        display_name: OptionalNullable[str] = UNSET,
        external_identifier: OptionalNullable[str] = UNSET,
        billing_details: OptionalNullable[
            Union[models.BillingDetailsInput, models.BillingDetailsInputTypedDict]
        ] = UNSET,
        account_number: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Buyer:
        r"""Add a buyer

        Create a new buyer record.

        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param display_name: The display name for the buyer.
        :param external_identifier: The merchant identifier for this buyer.
        :param billing_details: The billing name, address, email, and other fields for this buyer.
        :param account_number: The buyer account number
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AddBuyerRequest(
            merchant_account_id=merchant_account_id,
            buyer_create=models.BuyerCreate(
                display_name=display_name,
                external_identifier=external_identifier,
                billing_details=utils.get_pydantic_model(
                    billing_details, OptionalNullable[models.BillingDetailsInput]
                ),
                account_number=account_number,
            ),
        )

        req = self._build_request(
            method="POST",
            path="/buyers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AddBuyerGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.buyer_create, False, False, "json", models.BuyerCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="add_buyer",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.Buyer, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.Error400Data, http_res)
            raise errors.Error400(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.Error401Data, http_res)
            raise errors.Error401(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.Error403Data, http_res)
            raise errors.Error403(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.Error404Data, http_res)
            raise errors.Error404(response_data, http_res)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = unmarshal_json_response(errors.Error405Data, http_res)
            raise errors.Error405(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.Error409Data, http_res)
            raise errors.Error409(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = unmarshal_json_response(errors.Error425Data, http_res)
            raise errors.Error425(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(errors.Error429Data, http_res)
            raise errors.Error429(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.Error500Data, http_res)
            raise errors.Error500(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(errors.Error502Data, http_res)
            raise errors.Error502(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(errors.Error504Data, http_res)
            raise errors.Error504(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def create_async(
        self,
        *,
        merchant_account_id: Optional[str] = None,
        display_name: OptionalNullable[str] = UNSET,
        external_identifier: OptionalNullable[str] = UNSET,
        billing_details: OptionalNullable[
            Union[models.BillingDetailsInput, models.BillingDetailsInputTypedDict]
        ] = UNSET,
        account_number: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Buyer:
        r"""Add a buyer

        Create a new buyer record.

        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param display_name: The display name for the buyer.
        :param external_identifier: The merchant identifier for this buyer.
        :param billing_details: The billing name, address, email, and other fields for this buyer.
        :param account_number: The buyer account number
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AddBuyerRequest(
            merchant_account_id=merchant_account_id,
            buyer_create=models.BuyerCreate(
                display_name=display_name,
                external_identifier=external_identifier,
                billing_details=utils.get_pydantic_model(
                    billing_details, OptionalNullable[models.BillingDetailsInput]
                ),
                account_number=account_number,
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/buyers",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.AddBuyerGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.buyer_create, False, False, "json", models.BuyerCreate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="add_buyer",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.Buyer, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.Error400Data, http_res)
            raise errors.Error400(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.Error401Data, http_res)
            raise errors.Error401(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.Error403Data, http_res)
            raise errors.Error403(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.Error404Data, http_res)
            raise errors.Error404(response_data, http_res)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = unmarshal_json_response(errors.Error405Data, http_res)
            raise errors.Error405(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.Error409Data, http_res)
            raise errors.Error409(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = unmarshal_json_response(errors.Error425Data, http_res)
            raise errors.Error425(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(errors.Error429Data, http_res)
            raise errors.Error429(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.Error500Data, http_res)
            raise errors.Error500(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(errors.Error502Data, http_res)
            raise errors.Error502(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(errors.Error504Data, http_res)
            raise errors.Error504(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def get(
        self,
        *,
        buyer_id: str,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Buyer:
        r"""Get a buyer

        Fetches a buyer by its ID.

        :param buyer_id: The ID of the buyer to retrieve.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetBuyerRequest(
            buyer_id=buyer_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request(
            method="GET",
            path="/buyers/{buyer_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.GetBuyerGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_buyer",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Buyer, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.Error400Data, http_res)
            raise errors.Error400(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.Error401Data, http_res)
            raise errors.Error401(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.Error403Data, http_res)
            raise errors.Error403(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.Error404Data, http_res)
            raise errors.Error404(response_data, http_res)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = unmarshal_json_response(errors.Error405Data, http_res)
            raise errors.Error405(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.Error409Data, http_res)
            raise errors.Error409(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = unmarshal_json_response(errors.Error425Data, http_res)
            raise errors.Error425(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(errors.Error429Data, http_res)
            raise errors.Error429(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.Error500Data, http_res)
            raise errors.Error500(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(errors.Error502Data, http_res)
            raise errors.Error502(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(errors.Error504Data, http_res)
            raise errors.Error504(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def get_async(
        self,
        *,
        buyer_id: str,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Buyer:
        r"""Get a buyer

        Fetches a buyer by its ID.

        :param buyer_id: The ID of the buyer to retrieve.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.GetBuyerRequest(
            buyer_id=buyer_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request_async(
            method="GET",
            path="/buyers/{buyer_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.GetBuyerGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(200, 200, 1, 1000), True
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["5XX"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="get_buyer",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Buyer, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.Error400Data, http_res)
            raise errors.Error400(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.Error401Data, http_res)
            raise errors.Error401(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.Error403Data, http_res)
            raise errors.Error403(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.Error404Data, http_res)
            raise errors.Error404(response_data, http_res)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = unmarshal_json_response(errors.Error405Data, http_res)
            raise errors.Error405(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.Error409Data, http_res)
            raise errors.Error409(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = unmarshal_json_response(errors.Error425Data, http_res)
            raise errors.Error425(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(errors.Error429Data, http_res)
            raise errors.Error429(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.Error500Data, http_res)
            raise errors.Error500(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(errors.Error502Data, http_res)
            raise errors.Error502(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(errors.Error504Data, http_res)
            raise errors.Error504(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def update(
        self,
        *,
        buyer_id: str,
        merchant_account_id: Optional[str] = None,
        display_name: OptionalNullable[str] = UNSET,
        external_identifier: OptionalNullable[str] = UNSET,
        account_number: OptionalNullable[str] = UNSET,
        billing_details: OptionalNullable[
            Union[models.BillingDetailsInput, models.BillingDetailsInputTypedDict]
        ] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Buyer:
        r"""Update a buyer

        Updates a buyer record.

        :param buyer_id: The ID of the buyer to edit.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param display_name: The display name for the buyer.
        :param external_identifier: The merchant identifier for this buyer.
        :param account_number: The buyer account number
        :param billing_details: The billing name, address, email, and other fields for this buyer.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateBuyerRequest(
            buyer_id=buyer_id,
            merchant_account_id=merchant_account_id,
            buyer_update=models.BuyerUpdate(
                display_name=display_name,
                external_identifier=external_identifier,
                account_number=account_number,
                billing_details=utils.get_pydantic_model(
                    billing_details, OptionalNullable[models.BillingDetailsInput]
                ),
            ),
        )

        req = self._build_request(
            method="PUT",
            path="/buyers/{buyer_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.UpdateBuyerGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.buyer_update, False, False, "json", models.BuyerUpdate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="update_buyer",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Buyer, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.Error400Data, http_res)
            raise errors.Error400(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.Error401Data, http_res)
            raise errors.Error401(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.Error403Data, http_res)
            raise errors.Error403(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.Error404Data, http_res)
            raise errors.Error404(response_data, http_res)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = unmarshal_json_response(errors.Error405Data, http_res)
            raise errors.Error405(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.Error409Data, http_res)
            raise errors.Error409(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = unmarshal_json_response(errors.Error425Data, http_res)
            raise errors.Error425(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(errors.Error429Data, http_res)
            raise errors.Error429(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.Error500Data, http_res)
            raise errors.Error500(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(errors.Error502Data, http_res)
            raise errors.Error502(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(errors.Error504Data, http_res)
            raise errors.Error504(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def update_async(
        self,
        *,
        buyer_id: str,
        merchant_account_id: Optional[str] = None,
        display_name: OptionalNullable[str] = UNSET,
        external_identifier: OptionalNullable[str] = UNSET,
        account_number: OptionalNullable[str] = UNSET,
        billing_details: OptionalNullable[
            Union[models.BillingDetailsInput, models.BillingDetailsInputTypedDict]
        ] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.Buyer:
        r"""Update a buyer

        Updates a buyer record.

        :param buyer_id: The ID of the buyer to edit.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param display_name: The display name for the buyer.
        :param external_identifier: The merchant identifier for this buyer.
        :param account_number: The buyer account number
        :param billing_details: The billing name, address, email, and other fields for this buyer.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.UpdateBuyerRequest(
            buyer_id=buyer_id,
            merchant_account_id=merchant_account_id,
            buyer_update=models.BuyerUpdate(
                display_name=display_name,
                external_identifier=external_identifier,
                account_number=account_number,
                billing_details=utils.get_pydantic_model(
                    billing_details, OptionalNullable[models.BillingDetailsInput]
                ),
            ),
        )

        req = self._build_request_async(
            method="PUT",
            path="/buyers/{buyer_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.UpdateBuyerGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.buyer_update, False, False, "json", models.BuyerUpdate
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="update_buyer",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Buyer, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.Error400Data, http_res)
            raise errors.Error400(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.Error401Data, http_res)
            raise errors.Error401(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.Error403Data, http_res)
            raise errors.Error403(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.Error404Data, http_res)
            raise errors.Error404(response_data, http_res)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = unmarshal_json_response(errors.Error405Data, http_res)
            raise errors.Error405(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.Error409Data, http_res)
            raise errors.Error409(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = unmarshal_json_response(errors.Error425Data, http_res)
            raise errors.Error425(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(errors.Error429Data, http_res)
            raise errors.Error429(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.Error500Data, http_res)
            raise errors.Error500(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(errors.Error502Data, http_res)
            raise errors.Error502(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(errors.Error504Data, http_res)
            raise errors.Error504(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def delete(
        self,
        *,
        buyer_id: str,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a buyer

        Permanently removes a buyer record.

        :param buyer_id: The ID of the buyer to delete.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteBuyerRequest(
            buyer_id=buyer_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/buyers/{buyer_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.DeleteBuyerGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete_buyer",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.Error400Data, http_res)
            raise errors.Error400(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.Error401Data, http_res)
            raise errors.Error401(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.Error403Data, http_res)
            raise errors.Error403(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.Error404Data, http_res)
            raise errors.Error404(response_data, http_res)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = unmarshal_json_response(errors.Error405Data, http_res)
            raise errors.Error405(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.Error409Data, http_res)
            raise errors.Error409(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = unmarshal_json_response(errors.Error425Data, http_res)
            raise errors.Error425(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(errors.Error429Data, http_res)
            raise errors.Error429(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.Error500Data, http_res)
            raise errors.Error500(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(errors.Error502Data, http_res)
            raise errors.Error502(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(errors.Error504Data, http_res)
            raise errors.Error504(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def delete_async(
        self,
        *,
        buyer_id: str,
        merchant_account_id: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Delete a buyer

        Permanently removes a buyer record.

        :param buyer_id: The ID of the buyer to delete.
        :param merchant_account_id: The ID of the merchant account to use for this request.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteBuyerRequest(
            buyer_id=buyer_id,
            merchant_account_id=merchant_account_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/buyers/{buyer_id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.DeleteBuyerGlobals(
                merchant_account_id=self.sdk_configuration.globals.merchant_account_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="delete_buyer",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "405",
                "409",
                "422",
                "425",
                "429",
                "4XX",
                "500",
                "502",
                "504",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(errors.Error400Data, http_res)
            raise errors.Error400(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(errors.Error401Data, http_res)
            raise errors.Error401(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(errors.Error403Data, http_res)
            raise errors.Error403(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(errors.Error404Data, http_res)
            raise errors.Error404(response_data, http_res)
        if utils.match_response(http_res, "405", "application/json"):
            response_data = unmarshal_json_response(errors.Error405Data, http_res)
            raise errors.Error405(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(errors.Error409Data, http_res)
            raise errors.Error409(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "425", "application/json"):
            response_data = unmarshal_json_response(errors.Error425Data, http_res)
            raise errors.Error425(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(errors.Error429Data, http_res)
            raise errors.Error429(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(errors.Error500Data, http_res)
            raise errors.Error500(response_data, http_res)
        if utils.match_response(http_res, "502", "application/json"):
            response_data = unmarshal_json_response(errors.Error502Data, http_res)
            raise errors.Error502(response_data, http_res)
        if utils.match_response(http_res, "504", "application/json"):
            response_data = unmarshal_json_response(errors.Error504Data, http_res)
            raise errors.Error504(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
