"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .airline import Airline, AirlineTypedDict
from .cartitem import CartItem, CartItemTypedDict
from .guestbuyer_input import GuestBuyerInput, GuestBuyerInputTypedDict
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from pydantic import model_serializer
from typing import Dict, List, Optional
from typing_extensions import NotRequired, TypedDict


class CheckoutSessionCreateTypedDict(TypedDict):
    cart_items: NotRequired[Nullable[List[CartItemTypedDict]]]
    r"""An array of cart items that represents the line items of a transaction."""
    metadata: NotRequired[Nullable[Dict[str, str]]]
    r"""Any additional information about the transaction that you would like to store as key-value pairs. This data is passed to payment service providers that support it."""
    buyer: NotRequired[Nullable[GuestBuyerInputTypedDict]]
    r"""Provide buyer details for the transaction. No buyer resource will be created on Gr4vy when used."""
    airline: NotRequired[Nullable[AirlineTypedDict]]
    r"""The airline addendum data which describes the airline booking associated with this transaction."""
    expires_in: NotRequired[float]


class CheckoutSessionCreate(BaseModel):
    cart_items: OptionalNullable[List[CartItem]] = UNSET
    r"""An array of cart items that represents the line items of a transaction."""

    metadata: OptionalNullable[Dict[str, str]] = UNSET
    r"""Any additional information about the transaction that you would like to store as key-value pairs. This data is passed to payment service providers that support it."""

    buyer: OptionalNullable[GuestBuyerInput] = UNSET
    r"""Provide buyer details for the transaction. No buyer resource will be created on Gr4vy when used."""

    airline: OptionalNullable[Airline] = UNSET
    r"""The airline addendum data which describes the airline booking associated with this transaction."""

    expires_in: Optional[float] = 3600

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["cart_items", "metadata", "buyer", "airline", "expires_in"]
        nullable_fields = ["cart_items", "metadata", "buyer", "airline"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
