"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .definitionfieldformat import DefinitionFieldFormat
from gr4vy.types import BaseModel
from gr4vy.utils import validate_open_enum
import pydantic
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, TypedDict


class DefinitionFieldTypedDict(TypedDict):
    r"""A single field that needs to be submitted for a payment service when it is created."""

    key: str
    r"""The key of a field that can be submitted."""
    display_name: str
    r"""The human readable name for this field."""
    required: bool
    r"""Defines if this field is required when the service is created."""
    format_: DefinitionFieldFormat
    secret: bool
    r"""Defines if this field is secret. When `true` the field's value is not returned when querying the payment service information."""


class DefinitionField(BaseModel):
    r"""A single field that needs to be submitted for a payment service when it is created."""

    key: str
    r"""The key of a field that can be submitted."""

    display_name: str
    r"""The human readable name for this field."""

    required: bool
    r"""Defines if this field is required when the service is created."""

    format_: Annotated[
        Annotated[DefinitionFieldFormat, PlainValidator(validate_open_enum(False))],
        pydantic.Field(alias="format"),
    ]

    secret: bool
    r"""Defines if this field is secret. When `true` the field's value is not returned when querying the payment service information."""
