"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class NuveiPSEOptionsTypedDict(TypedDict):
    user_type: NotRequired[Nullable[str]]
    r"""Customer type (\"N\" for persona natural, \"J\" for persona jurídica)"""
    user_fis_number: NotRequired[Nullable[str]]
    r"""Customer’s document type"""
    fiscal_number: NotRequired[Nullable[str]]
    r"""Customer’s document number"""
    bank_code: NotRequired[Nullable[str]]
    r"""The bank code of the selected bank"""


class NuveiPSEOptions(BaseModel):
    user_type: Annotated[OptionalNullable[str], pydantic.Field(alias="userType")] = (
        UNSET
    )
    r"""Customer type (\"N\" for persona natural, \"J\" for persona jurídica)"""

    user_fis_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="userFisNumber")
    ] = UNSET
    r"""Customer’s document type"""

    fiscal_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="fiscalNumber")
    ] = UNSET
    r"""Customer’s document number"""

    bank_code: Annotated[OptionalNullable[str], pydantic.Field(alias="bankCode")] = (
        UNSET
    )
    r"""The bank code of the selected bank"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["userType", "userFisNumber", "fiscalNumber", "bankCode"]
        nullable_fields = ["userType", "userFisNumber", "fiscalNumber", "bankCode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
