"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .payoutcategory import PayoutCategory
from .payoutmerchantsummary import PayoutMerchantSummary, PayoutMerchantSummaryTypedDict
from .payoutpaymentservice import PayoutPaymentService, PayoutPaymentServiceTypedDict
from .payoutstatus import PayoutStatus
from .transactionbuyer import TransactionBuyer, TransactionBuyerTypedDict
from .transactionpaymentmethod import (
    TransactionPaymentMethod,
    TransactionPaymentMethodTypedDict,
)
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PayoutSummaryTypedDict(TypedDict):
    r"""PayoutSummary

    Represents a summary of a payout.
    """

    amount: int
    r"""The monetary amount for this payout, in the smallest currency unit for the given currency, for example `1299` cents to create an authorization for $12.99."""
    created_at: datetime
    r"""The date this payout was created at."""
    currency: str
    r"""A supported ISO-4217 currency code."""
    payment_method: TransactionPaymentMethodTypedDict
    payment_service: PayoutPaymentServiceTypedDict
    status: PayoutStatus
    updated_at: datetime
    r"""The date this payout was last updated at."""
    type: Literal["payout"]
    r"""Always `payout`."""
    id: NotRequired[Nullable[str]]
    r"""The ID for the payout."""
    buyer: NotRequired[Nullable[TransactionBuyerTypedDict]]
    r"""The buyer used for this payout."""
    category: NotRequired[Nullable[PayoutCategory]]
    r"""The type of payout to process."""
    external_identifier: NotRequired[Nullable[str]]
    r"""The merchant identifier for this payout."""
    merchant: NotRequired[Nullable[PayoutMerchantSummaryTypedDict]]
    r"""The merchant details associated to this payout."""
    merchant_account_id: NotRequired[Nullable[str]]
    r"""The ID of the merchant account this payout was created for."""
    payment_service_payout_id: NotRequired[Nullable[str]]
    r"""The ID of the payout in the underlying payment service."""


class PayoutSummary(BaseModel):
    r"""PayoutSummary

    Represents a summary of a payout.
    """

    amount: int
    r"""The monetary amount for this payout, in the smallest currency unit for the given currency, for example `1299` cents to create an authorization for $12.99."""

    created_at: datetime
    r"""The date this payout was created at."""

    currency: str
    r"""A supported ISO-4217 currency code."""

    payment_method: TransactionPaymentMethod

    payment_service: PayoutPaymentService

    status: Annotated[PayoutStatus, PlainValidator(validate_open_enum(False))]

    updated_at: datetime
    r"""The date this payout was last updated at."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["payout"]], AfterValidator(validate_const("payout"))
        ],
        pydantic.Field(alias="type"),
    ] = "payout"
    r"""Always `payout`."""

    id: OptionalNullable[str] = UNSET
    r"""The ID for the payout."""

    buyer: OptionalNullable[TransactionBuyer] = UNSET
    r"""The buyer used for this payout."""

    category: Annotated[
        OptionalNullable[PayoutCategory], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The type of payout to process."""

    external_identifier: OptionalNullable[str] = UNSET
    r"""The merchant identifier for this payout."""

    merchant: OptionalNullable[PayoutMerchantSummary] = UNSET
    r"""The merchant details associated to this payout."""

    merchant_account_id: OptionalNullable[str] = UNSET
    r"""The ID of the merchant account this payout was created for."""

    payment_service_payout_id: OptionalNullable[str] = UNSET
    r"""The ID of the payout in the underlying payment service."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "id",
            "buyer",
            "category",
            "external_identifier",
            "merchant",
            "merchant_account_id",
            "payment_service_payout_id",
        ]
        nullable_fields = [
            "id",
            "buyer",
            "category",
            "external_identifier",
            "merchant",
            "merchant_account_id",
            "payment_service_payout_id",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
