from __future__ import unicode_literals

import os
import imp
import django
import markdown
from django_comments_tree.render import render_draftjs, render_plain


PRJ_PATH = os.path.abspath(os.path.curdir)

DEBUG = True

ADMINS = (
    ('Joe, the Administrator', 'joe.bloggs@example.com'),
)

MANAGERS = ADMINS

DATABASES = {
    'default': {
        'ENGINE':   'django.db.backends.sqlite3',
        'NAME':     'django_comments_tree',
        'USER':     '',
        'PASSWORD': '',
        'HOST':     '',
        'PORT':     '',
    }
}

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Berlin'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'en-us'

SITE_ID = 1
#USE_TZ = True

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

STATIC_URL = "/static/"

STATICFILES_FINDERS = (
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
)

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = ''

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'

SECRET_KEY = 'v2824l&2-n+4zznbsk9c-ap5i)b3e8b+%*a=dxqlahm^%)68jn'

MIDDLEWARE = [
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
]

ROOT_URLCONF = 'django_comments_tree.tests.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [
            os.path.join(os.path.dirname(__file__), "templates"),
            os.path.join(os.path.dirname(__file__), "..", "templates"),
        ],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
            ]
        }
    }
]

INSTALLED_APPS = [
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.staticfiles',
    'django_comments_tree',
    'django_comments_tree.tests',
    'treebeard',
]
COMMENTS_APP = "django_comments_tree"

DEFAULT_FROM_EMAIL = "Alice Bloggs <alice@example.com>"

COMMENTS_TREE_CONFIRM_EMAIL = True
COMMENTS_TREE_SALT = b"es-war-einmal-una-bella-princesa-in-a-beautiful-castle"
COMMENTS_TREE_MAX_THREAD_LEVEL = 5
COMMENTS_TREE_MAX_THREAD_LEVEL_BY_APP_MODEL = {'tests.diary': 0}

COMMENTS_TREE_APP_MODEL_OPTIONS = {
    'tests.diary': {
        'allow_flagging': True,
        'allow_feedback': True,
        'show_feedback': True,
    }
}


TEST_RUNNER = 'django.test.runner.DiscoverRunner'

# Default types we can use for comments
MARKUP_FIELD_TYPES = (
    ('plain', render_plain),
    ('markdown', markdown.markdown),
    ('draftjs', render_draftjs),
)
