# Handoff Brief Template
*Template for comprehensive agent transitions*

**Document**: handoff-brief-template.md
**Created**: 2025-08-03
**Version**: 1.0
**Status**: Active Template

## Purpose

This template ensures complete context preservation during agent handoffs. Every transition between specialized craftspeople should use this format to maintain information integrity and enable seamless coordination.

## Handoff Brief Template

```markdown
# Agent Handoff Brief

**Handoff ID**: [Unique identifier - format: HB-YYYYMMDD-HHMMSS]
**Date**: [Current date from time MCP tool]
**Project**: [Project name and context]

## Transition Details

**From Agent**: [Agent name] - [Agent specialization]
**To Agent**: [Next agent name] - [Next agent specialization]
**Workflow Phase**: [Current phase and progression status]
**Handoff Type**: [Sequential/Parallel/Coordination/Error Recovery]

## Executive Summary

**Work Completed**: [Brief 2-3 sentence summary of completed work]
**Key Deliverables**: [Primary outputs created during this phase]
**Next Actions Required**: [Specific actions needed from receiving agent]
**Critical Context**: [Most important information for successful continuation]

## Detailed Context Summary

### Project Overview
**Objective**: [What we're building and why it matters]
**Scope**: [What's included and excluded in current work]
**Stakeholders**: [Who we're serving and their key needs]
**Success Criteria**: [How we'll know we've succeeded]

### Current State
**Phase Status**: [Where we are in the overall workflow]
**Completed Work**: [Detailed summary of work finished in this phase]
**Quality Validation**: [Confirmation that work meets craftsman standards]
**Dependencies Resolved**: [What dependencies were addressed]

### Research Findings

#### Market Research
**Key Findings**: [Important market insights discovered]
**Sources**: [Research sources with citations - URL, access date, relevant quotes]
**Validation**: [How findings were validated and cross-referenced]
**Implications**: [How research impacts decisions and approach]

#### Technical Research
**Key Findings**: [Important technical insights discovered]
**Sources**: [Technical sources with citations]
**Feasibility**: [Technical feasibility validation results]
**Alternatives**: [Alternative approaches considered and rejected]

#### Competitive Analysis
**Key Findings**: [Important competitive insights]
**Sources**: [Competitive research sources with citations]
**Positioning**: [How our approach compares to competitors]
**Opportunities**: [Gaps and opportunities identified]

## Decisions Made

### Primary Decisions
**Decision 1**: [Decision made]
- **Rationale**: [Why this decision was made]
- **Alternatives**: [Other options considered]
- **Evidence**: [Research backing the decision]
- **Impact**: [How this affects future work]

**Decision 2**: [Decision made]
- **Rationale**: [Why this decision was made]
- **Alternatives**: [Other options considered]
- **Evidence**: [Research backing the decision]
- **Impact**: [How this affects future work]

### Supporting Decisions
[Additional decisions made with brief rationale]

### Deferred Decisions
[Decisions that need to be made by subsequent agents with context]

## Deliverables Created

### Primary Deliverables
**File 1**: [Filename with full path]
- **Purpose**: [What this deliverable accomplishes]
- **Key Contents**: [Summary of important contents]
- **Quality Status**: [Confirmation of quality standards met]
- **Dependencies**: [What this deliverable depends on or enables]

**File 2**: [Filename with full path]
- **Purpose**: [What this deliverable accomplishes]
- **Key Contents**: [Summary of important contents]
- **Quality Status**: [Confirmation of quality standards met]
- **Dependencies**: [What this deliverable depends on or enables]

### Supporting Deliverables
[Additional files created with brief descriptions]

### Quality Validation
- [ ] All deliverables meet craftsman quality standards
- [ ] Research backing provided for all factual claims
- [ ] File organization follows .claude/ standards
- [ ] Documentation enables independent understanding
- [ ] Work worthy of showing another master craftsperson

## Context Files Updated

### WORKFLOW-STATE.md Updates
**Changes Made**: [What workflow state changes were recorded]
**Current Phase**: [Updated phase status]
**Next Actions**: [Actions recorded for subsequent phases]

### CONTEXT.md Updates
**Context Added**: [New context information added]
**Decisions Recorded**: [Decisions preserved in project context]
**Research Preserved**: [Research findings added to context]

### HANDOFF-LOG.md Updates
**Handoff Recorded**: [This handoff entry added to log]
**Success Metrics**: [Handoff success confirmation]
**Issues**: [Any issues encountered and resolved]

### SESSION-MEMORY.md Updates
**Session State**: [Current session state preserved]
**Temporary Context**: [Temporary information that needs preservation]
**Recovery Information**: [Information needed for session recovery]

## Next Actions Required

### Immediate Actions (Next Agent)
1. **Action 1**: [Specific action required]
   - **Context**: [Relevant context for this action]
   - **Resources**: [Resources available for this action]
   - **Success Criteria**: [How to know action is complete]

2. **Action 2**: [Specific action required]
   - **Context**: [Relevant context for this action]
   - **Resources**: [Resources available for this action]
   - **Success Criteria**: [How to know action is complete]

### Follow-up Actions (Subsequent Phases)
[Actions that will be needed in later phases]

### Dependencies
**Waiting For**: [What the next agent might be waiting for]
**Blockers**: [Any known blockers that need resolution]
**Escalation**: [When to escalate to human intervention]

## Research Context for Next Agent

### Research Tools Used
**MCP Tools**: [Which research tools were used and how]
**Research Queries**: [Key search terms and approaches used]
**Source Quality**: [Assessment of source quality and reliability]
**Research Gaps**: [Areas needing additional research]

### Citation Registry
**Source 1**: [Full citation with URL, access date, relevant quotes]
**Source 2**: [Full citation with URL, access date, relevant quotes]
[Continue for all sources used]

### Research Methodology
**Approach**: [How research was conducted]
**Validation**: [How sources were validated and cross-referenced]
**Currency**: [How current date context was maintained]
**Limitations**: [Any research limitations or gaps]

## Quality Assurance

### Craftsman Standards Met
- [ ] Work reflects intention and careful consideration
- [ ] Quality standards consistently maintained
- [ ] Research backing enables independent verification
- [ ] File organization prevents documentation sprawl
- [ ] Context preserved completely for next agent
- [ ] Output worthy of master craftsperson pride

### Quality Validation Details
**Review Process**: [How quality was validated]
**Standards Applied**: [Specific standards checked]
**Issues Resolved**: [Any quality issues found and resolved]
**Confirmation**: [Final quality confirmation]

## Risk Assessment and Mitigation

### Risks Identified
**Risk 1**: [Potential risk for next phases]
- **Impact**: [Potential impact if risk occurs]
- **Likelihood**: [Assessment of risk likelihood]
- **Mitigation**: [Steps taken or recommended for mitigation]

### Assumptions Made
**Assumption 1**: [Assumption made during work]
- **Basis**: [Why this assumption was reasonable]
- **Validation**: [How assumption could be validated]
- **Risk**: [What happens if assumption is wrong]

### Dependencies
**Dependency 1**: [External dependency identified]
- **Description**: [What we're dependent on]
- **Risk**: [What happens if dependency fails]
- **Mitigation**: [How to handle dependency failure]

## Communication Notes

### Stakeholder Updates
**Updates Needed**: [What stakeholders need to know]
**Communication Method**: [How updates should be communicated]
**Timing**: [When updates should be provided]

### Team Coordination
**Coordination Needed**: [What coordination is required]
**Other Agents**: [How this affects other agents in workflow]
**Synchronization**: [Any synchronization requirements]

## Success Validation

### Handoff Success Criteria
- [ ] Complete context transferred to next agent
- [ ] All deliverables meet quality standards
- [ ] Research findings properly documented and cited
- [ ] Next actions clearly defined and actionable
- [ ] Context files updated accurately
- [ ] Quality gates satisfied for phase completion

### Next Agent Confirmation
**Context Received**: [Confirmation that next agent has complete context]
**Understanding Verified**: [Confirmation that context is understood]
**Ready to Proceed**: [Confirmation that next agent can proceed]

## Additional Notes

### Lessons Learned
[Important lessons learned during this phase]

### Process Improvements
[Suggestions for improving the process based on this experience]

### Future Considerations
[Things to keep in mind for future phases or projects]

---

**Handoff Brief Created By**: [Agent name]
**Brief Quality Status**: ✅ Complete and Validated
**Next Agent Briefed**: [Confirmation of successful handoff]
**Handoff Log Updated**: ✅ Recorded in HANDOFF-LOG.md

*"A master craftsperson provides complete context that enables the next artisan to continue the work with full understanding and confidence."*
```

## Usage Instructions

### When to Use This Template
- **Every Agent Transition**: All handoffs between specialized agents
- **Phase Completions**: When completing major workflow phases
- **Error Recovery**: When recovering from failed handoffs
- **Complex Workflows**: Multi-agent coordination requiring detailed context

### How to Use This Template
1. **Copy Template**: Use complete template structure
2. **Fill All Sections**: Complete every section with relevant information
3. **Validate Quality**: Ensure all quality checkboxes are satisfied
4. **Update Context Files**: Update all relevant context files
5. **Confirm Handoff**: Verify next agent has complete context

### Quality Standards for Handoff Briefs
- **Completeness**: All template sections filled with relevant information
- **Accuracy**: All information is current and correct
- **Citations**: All research properly cited with verifiable sources
- **Clarity**: Next agent can understand and act on information
- **Context Preservation**: No information loss during transition

## Template Customization

### Agent-Specific Adaptations
Different agent specializations may need additional sections:
- **Planning Agents**: Extra focus on research findings and market context
- **Implementation Agents**: Extra focus on technical decisions and code context
- **Coordination Agents**: Extra focus on multi-agent workflow status

### Project-Specific Adaptations
Large or complex projects may need additional sections:
- **Stakeholder Context**: Additional stakeholder information
- **Compliance Context**: Regulatory or compliance considerations
- **Integration Context**: System integration complexities

## Validation Checklist

### Before Creating Handoff Brief
- [ ] All work completed to craftsman standards
- [ ] All research properly cited with current sources
- [ ] All deliverables created and validated
- [ ] All context files updated with current information

### After Creating Handoff Brief
- [ ] All template sections completed
- [ ] Quality standards verified and documented
- [ ] Context files updated with handoff information
- [ ] Next agent confirmed ready to proceed

---

**Template Maintainer**: ClaudeCraftsman Project Team
**Last Updated**: 2025-08-03
**Usage**: Required for all agent handoffs
**Quality Standard**: Must enable complete context preservation

*"The quality of a handoff reflects the craftsmanship of the giver and enables the excellence of the receiver."*
