# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawAccountingClient, RawAccountingClient

if typing.TYPE_CHECKING:
    from .resources.account_details.client import AccountDetailsClient, AsyncAccountDetailsClient
    from .resources.account_token.client import AccountTokenClient, AsyncAccountTokenClient
    from .resources.accounting_periods.client import AccountingPeriodsClient, AsyncAccountingPeriodsClient
    from .resources.accounts.client import AccountsClient, AsyncAccountsClient
    from .resources.addresses.client import AddressesClient, AsyncAddressesClient
    from .resources.async_passthrough.client import AsyncAsyncPassthroughClient
    from .resources.async_passthrough.client import (
        AsyncPassthroughClient as resources_accounting_resources_async_passthrough_client_AsyncPassthroughClient,
    )
    from .resources.async_tasks.client import AsyncAsyncTasksClient, AsyncTasksClient
    from .resources.attachments.client import AsyncAttachmentsClient, AttachmentsClient
    from .resources.audit_trail.client import AsyncAuditTrailClient, AuditTrailClient
    from .resources.available_actions.client import AsyncAvailableActionsClient, AvailableActionsClient
    from .resources.balance_sheets.client import AsyncBalanceSheetsClient, BalanceSheetsClient
    from .resources.bank_feed_accounts.client import AsyncBankFeedAccountsClient, BankFeedAccountsClient
    from .resources.bank_feed_transactions.client import AsyncBankFeedTransactionsClient, BankFeedTransactionsClient
    from .resources.cash_flow_statements.client import AsyncCashFlowStatementsClient, CashFlowStatementsClient
    from .resources.company_info.client import AsyncCompanyInfoClient, CompanyInfoClient
    from .resources.contacts.client import AsyncContactsClient, ContactsClient
    from .resources.credit_notes.client import AsyncCreditNotesClient, CreditNotesClient
    from .resources.delete_account.client import AsyncDeleteAccountClient, DeleteAccountClient
    from .resources.employees.client import AsyncEmployeesClient, EmployeesClient
    from .resources.expense_reports.client import AsyncExpenseReportsClient, ExpenseReportsClient
    from .resources.expenses.client import AsyncExpensesClient, ExpensesClient
    from .resources.field_mapping.client import AsyncFieldMappingClient, FieldMappingClient
    from .resources.force_resync.client import AsyncForceResyncClient, ForceResyncClient
    from .resources.general_ledger_transactions.client import (
        AsyncGeneralLedgerTransactionsClient,
        GeneralLedgerTransactionsClient,
    )
    from .resources.generate_key.client import AsyncGenerateKeyClient, GenerateKeyClient
    from .resources.income_statements.client import AsyncIncomeStatementsClient, IncomeStatementsClient
    from .resources.invoices.client import AsyncInvoicesClient, InvoicesClient
    from .resources.issues.client import AsyncIssuesClient, IssuesClient
    from .resources.items.client import AsyncItemsClient, ItemsClient
    from .resources.journal_entries.client import AsyncJournalEntriesClient, JournalEntriesClient
    from .resources.link_token.client import AsyncLinkTokenClient, LinkTokenClient
    from .resources.linked_accounts.client import AsyncLinkedAccountsClient, LinkedAccountsClient
    from .resources.passthrough.client import (
        AsyncPassthroughClient as resources_accounting_resources_passthrough_client_AsyncPassthroughClient,
    )
    from .resources.passthrough.client import PassthroughClient
    from .resources.payment_methods.client import AsyncPaymentMethodsClient, PaymentMethodsClient
    from .resources.payment_terms.client import AsyncPaymentTermsClient, PaymentTermsClient
    from .resources.payments.client import AsyncPaymentsClient, PaymentsClient
    from .resources.phone_numbers.client import AsyncPhoneNumbersClient, PhoneNumbersClient
    from .resources.projects.client import AsyncProjectsClient, ProjectsClient
    from .resources.purchase_orders.client import AsyncPurchaseOrdersClient, PurchaseOrdersClient
    from .resources.regenerate_key.client import AsyncRegenerateKeyClient, RegenerateKeyClient
    from .resources.scopes.client import AsyncScopesClient, ScopesClient
    from .resources.sync_status.client import AsyncSyncStatusClient, SyncStatusClient
    from .resources.tax_rates.client import AsyncTaxRatesClient, TaxRatesClient
    from .resources.tracking_categories.client import AsyncTrackingCategoriesClient, TrackingCategoriesClient
    from .resources.transactions.client import AsyncTransactionsClient, TransactionsClient
    from .resources.vendor_credits.client import AsyncVendorCreditsClient, VendorCreditsClient
    from .resources.webhook_receivers.client import AsyncWebhookReceiversClient, WebhookReceiversClient


class AccountingClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAccountingClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._account_details: typing.Optional[AccountDetailsClient] = None
        self._account_token: typing.Optional[AccountTokenClient] = None
        self._accounting_periods: typing.Optional[AccountingPeriodsClient] = None
        self._accounts: typing.Optional[AccountsClient] = None
        self._addresses: typing.Optional[AddressesClient] = None
        self._async_passthrough: typing.Optional[
            resources_accounting_resources_async_passthrough_client_AsyncPassthroughClient
        ] = None
        self._async_tasks: typing.Optional[AsyncTasksClient] = None
        self._attachments: typing.Optional[AttachmentsClient] = None
        self._audit_trail: typing.Optional[AuditTrailClient] = None
        self._available_actions: typing.Optional[AvailableActionsClient] = None
        self._balance_sheets: typing.Optional[BalanceSheetsClient] = None
        self._bank_feed_accounts: typing.Optional[BankFeedAccountsClient] = None
        self._bank_feed_transactions: typing.Optional[BankFeedTransactionsClient] = None
        self._cash_flow_statements: typing.Optional[CashFlowStatementsClient] = None
        self._company_info: typing.Optional[CompanyInfoClient] = None
        self._contacts: typing.Optional[ContactsClient] = None
        self._credit_notes: typing.Optional[CreditNotesClient] = None
        self._scopes: typing.Optional[ScopesClient] = None
        self._delete_account: typing.Optional[DeleteAccountClient] = None
        self._employees: typing.Optional[EmployeesClient] = None
        self._expense_reports: typing.Optional[ExpenseReportsClient] = None
        self._expenses: typing.Optional[ExpensesClient] = None
        self._field_mapping: typing.Optional[FieldMappingClient] = None
        self._general_ledger_transactions: typing.Optional[GeneralLedgerTransactionsClient] = None
        self._generate_key: typing.Optional[GenerateKeyClient] = None
        self._income_statements: typing.Optional[IncomeStatementsClient] = None
        self._invoices: typing.Optional[InvoicesClient] = None
        self._issues: typing.Optional[IssuesClient] = None
        self._items: typing.Optional[ItemsClient] = None
        self._journal_entries: typing.Optional[JournalEntriesClient] = None
        self._link_token: typing.Optional[LinkTokenClient] = None
        self._linked_accounts: typing.Optional[LinkedAccountsClient] = None
        self._passthrough: typing.Optional[PassthroughClient] = None
        self._payment_methods: typing.Optional[PaymentMethodsClient] = None
        self._payment_terms: typing.Optional[PaymentTermsClient] = None
        self._payments: typing.Optional[PaymentsClient] = None
        self._phone_numbers: typing.Optional[PhoneNumbersClient] = None
        self._projects: typing.Optional[ProjectsClient] = None
        self._purchase_orders: typing.Optional[PurchaseOrdersClient] = None
        self._regenerate_key: typing.Optional[RegenerateKeyClient] = None
        self._sync_status: typing.Optional[SyncStatusClient] = None
        self._force_resync: typing.Optional[ForceResyncClient] = None
        self._tax_rates: typing.Optional[TaxRatesClient] = None
        self._tracking_categories: typing.Optional[TrackingCategoriesClient] = None
        self._transactions: typing.Optional[TransactionsClient] = None
        self._vendor_credits: typing.Optional[VendorCreditsClient] = None
        self._webhook_receivers: typing.Optional[WebhookReceiversClient] = None

    @property
    def with_raw_response(self) -> RawAccountingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAccountingClient
        """
        return self._raw_client

    @property
    def account_details(self):
        if self._account_details is None:
            from .resources.account_details.client import AccountDetailsClient  # noqa: E402

            self._account_details = AccountDetailsClient(client_wrapper=self._client_wrapper)
        return self._account_details

    @property
    def account_token(self):
        if self._account_token is None:
            from .resources.account_token.client import AccountTokenClient  # noqa: E402

            self._account_token = AccountTokenClient(client_wrapper=self._client_wrapper)
        return self._account_token

    @property
    def accounting_periods(self):
        if self._accounting_periods is None:
            from .resources.accounting_periods.client import AccountingPeriodsClient  # noqa: E402

            self._accounting_periods = AccountingPeriodsClient(client_wrapper=self._client_wrapper)
        return self._accounting_periods

    @property
    def accounts(self):
        if self._accounts is None:
            from .resources.accounts.client import AccountsClient  # noqa: E402

            self._accounts = AccountsClient(client_wrapper=self._client_wrapper)
        return self._accounts

    @property
    def addresses(self):
        if self._addresses is None:
            from .resources.addresses.client import AddressesClient  # noqa: E402

            self._addresses = AddressesClient(client_wrapper=self._client_wrapper)
        return self._addresses

    @property
    def async_passthrough(self):
        if self._async_passthrough is None:
            from .resources.async_passthrough.client import (
                AsyncPassthroughClient as resources_accounting_resources_async_passthrough_client_AsyncPassthroughClient,  # noqa: E402
            )

            self._async_passthrough = resources_accounting_resources_async_passthrough_client_AsyncPassthroughClient(
                client_wrapper=self._client_wrapper
            )
        return self._async_passthrough

    @property
    def async_tasks(self):
        if self._async_tasks is None:
            from .resources.async_tasks.client import AsyncTasksClient  # noqa: E402

            self._async_tasks = AsyncTasksClient(client_wrapper=self._client_wrapper)
        return self._async_tasks

    @property
    def attachments(self):
        if self._attachments is None:
            from .resources.attachments.client import AttachmentsClient  # noqa: E402

            self._attachments = AttachmentsClient(client_wrapper=self._client_wrapper)
        return self._attachments

    @property
    def audit_trail(self):
        if self._audit_trail is None:
            from .resources.audit_trail.client import AuditTrailClient  # noqa: E402

            self._audit_trail = AuditTrailClient(client_wrapper=self._client_wrapper)
        return self._audit_trail

    @property
    def available_actions(self):
        if self._available_actions is None:
            from .resources.available_actions.client import AvailableActionsClient  # noqa: E402

            self._available_actions = AvailableActionsClient(client_wrapper=self._client_wrapper)
        return self._available_actions

    @property
    def balance_sheets(self):
        if self._balance_sheets is None:
            from .resources.balance_sheets.client import BalanceSheetsClient  # noqa: E402

            self._balance_sheets = BalanceSheetsClient(client_wrapper=self._client_wrapper)
        return self._balance_sheets

    @property
    def bank_feed_accounts(self):
        if self._bank_feed_accounts is None:
            from .resources.bank_feed_accounts.client import BankFeedAccountsClient  # noqa: E402

            self._bank_feed_accounts = BankFeedAccountsClient(client_wrapper=self._client_wrapper)
        return self._bank_feed_accounts

    @property
    def bank_feed_transactions(self):
        if self._bank_feed_transactions is None:
            from .resources.bank_feed_transactions.client import BankFeedTransactionsClient  # noqa: E402

            self._bank_feed_transactions = BankFeedTransactionsClient(client_wrapper=self._client_wrapper)
        return self._bank_feed_transactions

    @property
    def cash_flow_statements(self):
        if self._cash_flow_statements is None:
            from .resources.cash_flow_statements.client import CashFlowStatementsClient  # noqa: E402

            self._cash_flow_statements = CashFlowStatementsClient(client_wrapper=self._client_wrapper)
        return self._cash_flow_statements

    @property
    def company_info(self):
        if self._company_info is None:
            from .resources.company_info.client import CompanyInfoClient  # noqa: E402

            self._company_info = CompanyInfoClient(client_wrapper=self._client_wrapper)
        return self._company_info

    @property
    def contacts(self):
        if self._contacts is None:
            from .resources.contacts.client import ContactsClient  # noqa: E402

            self._contacts = ContactsClient(client_wrapper=self._client_wrapper)
        return self._contacts

    @property
    def credit_notes(self):
        if self._credit_notes is None:
            from .resources.credit_notes.client import CreditNotesClient  # noqa: E402

            self._credit_notes = CreditNotesClient(client_wrapper=self._client_wrapper)
        return self._credit_notes

    @property
    def scopes(self):
        if self._scopes is None:
            from .resources.scopes.client import ScopesClient  # noqa: E402

            self._scopes = ScopesClient(client_wrapper=self._client_wrapper)
        return self._scopes

    @property
    def delete_account(self):
        if self._delete_account is None:
            from .resources.delete_account.client import DeleteAccountClient  # noqa: E402

            self._delete_account = DeleteAccountClient(client_wrapper=self._client_wrapper)
        return self._delete_account

    @property
    def employees(self):
        if self._employees is None:
            from .resources.employees.client import EmployeesClient  # noqa: E402

            self._employees = EmployeesClient(client_wrapper=self._client_wrapper)
        return self._employees

    @property
    def expense_reports(self):
        if self._expense_reports is None:
            from .resources.expense_reports.client import ExpenseReportsClient  # noqa: E402

            self._expense_reports = ExpenseReportsClient(client_wrapper=self._client_wrapper)
        return self._expense_reports

    @property
    def expenses(self):
        if self._expenses is None:
            from .resources.expenses.client import ExpensesClient  # noqa: E402

            self._expenses = ExpensesClient(client_wrapper=self._client_wrapper)
        return self._expenses

    @property
    def field_mapping(self):
        if self._field_mapping is None:
            from .resources.field_mapping.client import FieldMappingClient  # noqa: E402

            self._field_mapping = FieldMappingClient(client_wrapper=self._client_wrapper)
        return self._field_mapping

    @property
    def general_ledger_transactions(self):
        if self._general_ledger_transactions is None:
            from .resources.general_ledger_transactions.client import GeneralLedgerTransactionsClient  # noqa: E402

            self._general_ledger_transactions = GeneralLedgerTransactionsClient(client_wrapper=self._client_wrapper)
        return self._general_ledger_transactions

    @property
    def generate_key(self):
        if self._generate_key is None:
            from .resources.generate_key.client import GenerateKeyClient  # noqa: E402

            self._generate_key = GenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._generate_key

    @property
    def income_statements(self):
        if self._income_statements is None:
            from .resources.income_statements.client import IncomeStatementsClient  # noqa: E402

            self._income_statements = IncomeStatementsClient(client_wrapper=self._client_wrapper)
        return self._income_statements

    @property
    def invoices(self):
        if self._invoices is None:
            from .resources.invoices.client import InvoicesClient  # noqa: E402

            self._invoices = InvoicesClient(client_wrapper=self._client_wrapper)
        return self._invoices

    @property
    def issues(self):
        if self._issues is None:
            from .resources.issues.client import IssuesClient  # noqa: E402

            self._issues = IssuesClient(client_wrapper=self._client_wrapper)
        return self._issues

    @property
    def items(self):
        if self._items is None:
            from .resources.items.client import ItemsClient  # noqa: E402

            self._items = ItemsClient(client_wrapper=self._client_wrapper)
        return self._items

    @property
    def journal_entries(self):
        if self._journal_entries is None:
            from .resources.journal_entries.client import JournalEntriesClient  # noqa: E402

            self._journal_entries = JournalEntriesClient(client_wrapper=self._client_wrapper)
        return self._journal_entries

    @property
    def link_token(self):
        if self._link_token is None:
            from .resources.link_token.client import LinkTokenClient  # noqa: E402

            self._link_token = LinkTokenClient(client_wrapper=self._client_wrapper)
        return self._link_token

    @property
    def linked_accounts(self):
        if self._linked_accounts is None:
            from .resources.linked_accounts.client import LinkedAccountsClient  # noqa: E402

            self._linked_accounts = LinkedAccountsClient(client_wrapper=self._client_wrapper)
        return self._linked_accounts

    @property
    def passthrough(self):
        if self._passthrough is None:
            from .resources.passthrough.client import PassthroughClient  # noqa: E402

            self._passthrough = PassthroughClient(client_wrapper=self._client_wrapper)
        return self._passthrough

    @property
    def payment_methods(self):
        if self._payment_methods is None:
            from .resources.payment_methods.client import PaymentMethodsClient  # noqa: E402

            self._payment_methods = PaymentMethodsClient(client_wrapper=self._client_wrapper)
        return self._payment_methods

    @property
    def payment_terms(self):
        if self._payment_terms is None:
            from .resources.payment_terms.client import PaymentTermsClient  # noqa: E402

            self._payment_terms = PaymentTermsClient(client_wrapper=self._client_wrapper)
        return self._payment_terms

    @property
    def payments(self):
        if self._payments is None:
            from .resources.payments.client import PaymentsClient  # noqa: E402

            self._payments = PaymentsClient(client_wrapper=self._client_wrapper)
        return self._payments

    @property
    def phone_numbers(self):
        if self._phone_numbers is None:
            from .resources.phone_numbers.client import PhoneNumbersClient  # noqa: E402

            self._phone_numbers = PhoneNumbersClient(client_wrapper=self._client_wrapper)
        return self._phone_numbers

    @property
    def projects(self):
        if self._projects is None:
            from .resources.projects.client import ProjectsClient  # noqa: E402

            self._projects = ProjectsClient(client_wrapper=self._client_wrapper)
        return self._projects

    @property
    def purchase_orders(self):
        if self._purchase_orders is None:
            from .resources.purchase_orders.client import PurchaseOrdersClient  # noqa: E402

            self._purchase_orders = PurchaseOrdersClient(client_wrapper=self._client_wrapper)
        return self._purchase_orders

    @property
    def regenerate_key(self):
        if self._regenerate_key is None:
            from .resources.regenerate_key.client import RegenerateKeyClient  # noqa: E402

            self._regenerate_key = RegenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._regenerate_key

    @property
    def sync_status(self):
        if self._sync_status is None:
            from .resources.sync_status.client import SyncStatusClient  # noqa: E402

            self._sync_status = SyncStatusClient(client_wrapper=self._client_wrapper)
        return self._sync_status

    @property
    def force_resync(self):
        if self._force_resync is None:
            from .resources.force_resync.client import ForceResyncClient  # noqa: E402

            self._force_resync = ForceResyncClient(client_wrapper=self._client_wrapper)
        return self._force_resync

    @property
    def tax_rates(self):
        if self._tax_rates is None:
            from .resources.tax_rates.client import TaxRatesClient  # noqa: E402

            self._tax_rates = TaxRatesClient(client_wrapper=self._client_wrapper)
        return self._tax_rates

    @property
    def tracking_categories(self):
        if self._tracking_categories is None:
            from .resources.tracking_categories.client import TrackingCategoriesClient  # noqa: E402

            self._tracking_categories = TrackingCategoriesClient(client_wrapper=self._client_wrapper)
        return self._tracking_categories

    @property
    def transactions(self):
        if self._transactions is None:
            from .resources.transactions.client import TransactionsClient  # noqa: E402

            self._transactions = TransactionsClient(client_wrapper=self._client_wrapper)
        return self._transactions

    @property
    def vendor_credits(self):
        if self._vendor_credits is None:
            from .resources.vendor_credits.client import VendorCreditsClient  # noqa: E402

            self._vendor_credits = VendorCreditsClient(client_wrapper=self._client_wrapper)
        return self._vendor_credits

    @property
    def webhook_receivers(self):
        if self._webhook_receivers is None:
            from .resources.webhook_receivers.client import WebhookReceiversClient  # noqa: E402

            self._webhook_receivers = WebhookReceiversClient(client_wrapper=self._client_wrapper)
        return self._webhook_receivers


class AsyncAccountingClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAccountingClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._account_details: typing.Optional[AsyncAccountDetailsClient] = None
        self._account_token: typing.Optional[AsyncAccountTokenClient] = None
        self._accounting_periods: typing.Optional[AsyncAccountingPeriodsClient] = None
        self._accounts: typing.Optional[AsyncAccountsClient] = None
        self._addresses: typing.Optional[AsyncAddressesClient] = None
        self._async_passthrough: typing.Optional[AsyncAsyncPassthroughClient] = None
        self._async_tasks: typing.Optional[AsyncAsyncTasksClient] = None
        self._attachments: typing.Optional[AsyncAttachmentsClient] = None
        self._audit_trail: typing.Optional[AsyncAuditTrailClient] = None
        self._available_actions: typing.Optional[AsyncAvailableActionsClient] = None
        self._balance_sheets: typing.Optional[AsyncBalanceSheetsClient] = None
        self._bank_feed_accounts: typing.Optional[AsyncBankFeedAccountsClient] = None
        self._bank_feed_transactions: typing.Optional[AsyncBankFeedTransactionsClient] = None
        self._cash_flow_statements: typing.Optional[AsyncCashFlowStatementsClient] = None
        self._company_info: typing.Optional[AsyncCompanyInfoClient] = None
        self._contacts: typing.Optional[AsyncContactsClient] = None
        self._credit_notes: typing.Optional[AsyncCreditNotesClient] = None
        self._scopes: typing.Optional[AsyncScopesClient] = None
        self._delete_account: typing.Optional[AsyncDeleteAccountClient] = None
        self._employees: typing.Optional[AsyncEmployeesClient] = None
        self._expense_reports: typing.Optional[AsyncExpenseReportsClient] = None
        self._expenses: typing.Optional[AsyncExpensesClient] = None
        self._field_mapping: typing.Optional[AsyncFieldMappingClient] = None
        self._general_ledger_transactions: typing.Optional[AsyncGeneralLedgerTransactionsClient] = None
        self._generate_key: typing.Optional[AsyncGenerateKeyClient] = None
        self._income_statements: typing.Optional[AsyncIncomeStatementsClient] = None
        self._invoices: typing.Optional[AsyncInvoicesClient] = None
        self._issues: typing.Optional[AsyncIssuesClient] = None
        self._items: typing.Optional[AsyncItemsClient] = None
        self._journal_entries: typing.Optional[AsyncJournalEntriesClient] = None
        self._link_token: typing.Optional[AsyncLinkTokenClient] = None
        self._linked_accounts: typing.Optional[AsyncLinkedAccountsClient] = None
        self._passthrough: typing.Optional[resources_accounting_resources_passthrough_client_AsyncPassthroughClient] = (
            None
        )
        self._payment_methods: typing.Optional[AsyncPaymentMethodsClient] = None
        self._payment_terms: typing.Optional[AsyncPaymentTermsClient] = None
        self._payments: typing.Optional[AsyncPaymentsClient] = None
        self._phone_numbers: typing.Optional[AsyncPhoneNumbersClient] = None
        self._projects: typing.Optional[AsyncProjectsClient] = None
        self._purchase_orders: typing.Optional[AsyncPurchaseOrdersClient] = None
        self._regenerate_key: typing.Optional[AsyncRegenerateKeyClient] = None
        self._sync_status: typing.Optional[AsyncSyncStatusClient] = None
        self._force_resync: typing.Optional[AsyncForceResyncClient] = None
        self._tax_rates: typing.Optional[AsyncTaxRatesClient] = None
        self._tracking_categories: typing.Optional[AsyncTrackingCategoriesClient] = None
        self._transactions: typing.Optional[AsyncTransactionsClient] = None
        self._vendor_credits: typing.Optional[AsyncVendorCreditsClient] = None
        self._webhook_receivers: typing.Optional[AsyncWebhookReceiversClient] = None

    @property
    def with_raw_response(self) -> AsyncRawAccountingClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAccountingClient
        """
        return self._raw_client

    @property
    def account_details(self):
        if self._account_details is None:
            from .resources.account_details.client import AsyncAccountDetailsClient  # noqa: E402

            self._account_details = AsyncAccountDetailsClient(client_wrapper=self._client_wrapper)
        return self._account_details

    @property
    def account_token(self):
        if self._account_token is None:
            from .resources.account_token.client import AsyncAccountTokenClient  # noqa: E402

            self._account_token = AsyncAccountTokenClient(client_wrapper=self._client_wrapper)
        return self._account_token

    @property
    def accounting_periods(self):
        if self._accounting_periods is None:
            from .resources.accounting_periods.client import AsyncAccountingPeriodsClient  # noqa: E402

            self._accounting_periods = AsyncAccountingPeriodsClient(client_wrapper=self._client_wrapper)
        return self._accounting_periods

    @property
    def accounts(self):
        if self._accounts is None:
            from .resources.accounts.client import AsyncAccountsClient  # noqa: E402

            self._accounts = AsyncAccountsClient(client_wrapper=self._client_wrapper)
        return self._accounts

    @property
    def addresses(self):
        if self._addresses is None:
            from .resources.addresses.client import AsyncAddressesClient  # noqa: E402

            self._addresses = AsyncAddressesClient(client_wrapper=self._client_wrapper)
        return self._addresses

    @property
    def async_passthrough(self):
        if self._async_passthrough is None:
            from .resources.async_passthrough.client import AsyncAsyncPassthroughClient  # noqa: E402

            self._async_passthrough = AsyncAsyncPassthroughClient(client_wrapper=self._client_wrapper)
        return self._async_passthrough

    @property
    def async_tasks(self):
        if self._async_tasks is None:
            from .resources.async_tasks.client import AsyncAsyncTasksClient  # noqa: E402

            self._async_tasks = AsyncAsyncTasksClient(client_wrapper=self._client_wrapper)
        return self._async_tasks

    @property
    def attachments(self):
        if self._attachments is None:
            from .resources.attachments.client import AsyncAttachmentsClient  # noqa: E402

            self._attachments = AsyncAttachmentsClient(client_wrapper=self._client_wrapper)
        return self._attachments

    @property
    def audit_trail(self):
        if self._audit_trail is None:
            from .resources.audit_trail.client import AsyncAuditTrailClient  # noqa: E402

            self._audit_trail = AsyncAuditTrailClient(client_wrapper=self._client_wrapper)
        return self._audit_trail

    @property
    def available_actions(self):
        if self._available_actions is None:
            from .resources.available_actions.client import AsyncAvailableActionsClient  # noqa: E402

            self._available_actions = AsyncAvailableActionsClient(client_wrapper=self._client_wrapper)
        return self._available_actions

    @property
    def balance_sheets(self):
        if self._balance_sheets is None:
            from .resources.balance_sheets.client import AsyncBalanceSheetsClient  # noqa: E402

            self._balance_sheets = AsyncBalanceSheetsClient(client_wrapper=self._client_wrapper)
        return self._balance_sheets

    @property
    def bank_feed_accounts(self):
        if self._bank_feed_accounts is None:
            from .resources.bank_feed_accounts.client import AsyncBankFeedAccountsClient  # noqa: E402

            self._bank_feed_accounts = AsyncBankFeedAccountsClient(client_wrapper=self._client_wrapper)
        return self._bank_feed_accounts

    @property
    def bank_feed_transactions(self):
        if self._bank_feed_transactions is None:
            from .resources.bank_feed_transactions.client import AsyncBankFeedTransactionsClient  # noqa: E402

            self._bank_feed_transactions = AsyncBankFeedTransactionsClient(client_wrapper=self._client_wrapper)
        return self._bank_feed_transactions

    @property
    def cash_flow_statements(self):
        if self._cash_flow_statements is None:
            from .resources.cash_flow_statements.client import AsyncCashFlowStatementsClient  # noqa: E402

            self._cash_flow_statements = AsyncCashFlowStatementsClient(client_wrapper=self._client_wrapper)
        return self._cash_flow_statements

    @property
    def company_info(self):
        if self._company_info is None:
            from .resources.company_info.client import AsyncCompanyInfoClient  # noqa: E402

            self._company_info = AsyncCompanyInfoClient(client_wrapper=self._client_wrapper)
        return self._company_info

    @property
    def contacts(self):
        if self._contacts is None:
            from .resources.contacts.client import AsyncContactsClient  # noqa: E402

            self._contacts = AsyncContactsClient(client_wrapper=self._client_wrapper)
        return self._contacts

    @property
    def credit_notes(self):
        if self._credit_notes is None:
            from .resources.credit_notes.client import AsyncCreditNotesClient  # noqa: E402

            self._credit_notes = AsyncCreditNotesClient(client_wrapper=self._client_wrapper)
        return self._credit_notes

    @property
    def scopes(self):
        if self._scopes is None:
            from .resources.scopes.client import AsyncScopesClient  # noqa: E402

            self._scopes = AsyncScopesClient(client_wrapper=self._client_wrapper)
        return self._scopes

    @property
    def delete_account(self):
        if self._delete_account is None:
            from .resources.delete_account.client import AsyncDeleteAccountClient  # noqa: E402

            self._delete_account = AsyncDeleteAccountClient(client_wrapper=self._client_wrapper)
        return self._delete_account

    @property
    def employees(self):
        if self._employees is None:
            from .resources.employees.client import AsyncEmployeesClient  # noqa: E402

            self._employees = AsyncEmployeesClient(client_wrapper=self._client_wrapper)
        return self._employees

    @property
    def expense_reports(self):
        if self._expense_reports is None:
            from .resources.expense_reports.client import AsyncExpenseReportsClient  # noqa: E402

            self._expense_reports = AsyncExpenseReportsClient(client_wrapper=self._client_wrapper)
        return self._expense_reports

    @property
    def expenses(self):
        if self._expenses is None:
            from .resources.expenses.client import AsyncExpensesClient  # noqa: E402

            self._expenses = AsyncExpensesClient(client_wrapper=self._client_wrapper)
        return self._expenses

    @property
    def field_mapping(self):
        if self._field_mapping is None:
            from .resources.field_mapping.client import AsyncFieldMappingClient  # noqa: E402

            self._field_mapping = AsyncFieldMappingClient(client_wrapper=self._client_wrapper)
        return self._field_mapping

    @property
    def general_ledger_transactions(self):
        if self._general_ledger_transactions is None:
            from .resources.general_ledger_transactions.client import AsyncGeneralLedgerTransactionsClient  # noqa: E402

            self._general_ledger_transactions = AsyncGeneralLedgerTransactionsClient(
                client_wrapper=self._client_wrapper
            )
        return self._general_ledger_transactions

    @property
    def generate_key(self):
        if self._generate_key is None:
            from .resources.generate_key.client import AsyncGenerateKeyClient  # noqa: E402

            self._generate_key = AsyncGenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._generate_key

    @property
    def income_statements(self):
        if self._income_statements is None:
            from .resources.income_statements.client import AsyncIncomeStatementsClient  # noqa: E402

            self._income_statements = AsyncIncomeStatementsClient(client_wrapper=self._client_wrapper)
        return self._income_statements

    @property
    def invoices(self):
        if self._invoices is None:
            from .resources.invoices.client import AsyncInvoicesClient  # noqa: E402

            self._invoices = AsyncInvoicesClient(client_wrapper=self._client_wrapper)
        return self._invoices

    @property
    def issues(self):
        if self._issues is None:
            from .resources.issues.client import AsyncIssuesClient  # noqa: E402

            self._issues = AsyncIssuesClient(client_wrapper=self._client_wrapper)
        return self._issues

    @property
    def items(self):
        if self._items is None:
            from .resources.items.client import AsyncItemsClient  # noqa: E402

            self._items = AsyncItemsClient(client_wrapper=self._client_wrapper)
        return self._items

    @property
    def journal_entries(self):
        if self._journal_entries is None:
            from .resources.journal_entries.client import AsyncJournalEntriesClient  # noqa: E402

            self._journal_entries = AsyncJournalEntriesClient(client_wrapper=self._client_wrapper)
        return self._journal_entries

    @property
    def link_token(self):
        if self._link_token is None:
            from .resources.link_token.client import AsyncLinkTokenClient  # noqa: E402

            self._link_token = AsyncLinkTokenClient(client_wrapper=self._client_wrapper)
        return self._link_token

    @property
    def linked_accounts(self):
        if self._linked_accounts is None:
            from .resources.linked_accounts.client import AsyncLinkedAccountsClient  # noqa: E402

            self._linked_accounts = AsyncLinkedAccountsClient(client_wrapper=self._client_wrapper)
        return self._linked_accounts

    @property
    def passthrough(self):
        if self._passthrough is None:
            from .resources.passthrough.client import (
                AsyncPassthroughClient as resources_accounting_resources_passthrough_client_AsyncPassthroughClient,  # noqa: E402
            )

            self._passthrough = resources_accounting_resources_passthrough_client_AsyncPassthroughClient(
                client_wrapper=self._client_wrapper
            )
        return self._passthrough

    @property
    def payment_methods(self):
        if self._payment_methods is None:
            from .resources.payment_methods.client import AsyncPaymentMethodsClient  # noqa: E402

            self._payment_methods = AsyncPaymentMethodsClient(client_wrapper=self._client_wrapper)
        return self._payment_methods

    @property
    def payment_terms(self):
        if self._payment_terms is None:
            from .resources.payment_terms.client import AsyncPaymentTermsClient  # noqa: E402

            self._payment_terms = AsyncPaymentTermsClient(client_wrapper=self._client_wrapper)
        return self._payment_terms

    @property
    def payments(self):
        if self._payments is None:
            from .resources.payments.client import AsyncPaymentsClient  # noqa: E402

            self._payments = AsyncPaymentsClient(client_wrapper=self._client_wrapper)
        return self._payments

    @property
    def phone_numbers(self):
        if self._phone_numbers is None:
            from .resources.phone_numbers.client import AsyncPhoneNumbersClient  # noqa: E402

            self._phone_numbers = AsyncPhoneNumbersClient(client_wrapper=self._client_wrapper)
        return self._phone_numbers

    @property
    def projects(self):
        if self._projects is None:
            from .resources.projects.client import AsyncProjectsClient  # noqa: E402

            self._projects = AsyncProjectsClient(client_wrapper=self._client_wrapper)
        return self._projects

    @property
    def purchase_orders(self):
        if self._purchase_orders is None:
            from .resources.purchase_orders.client import AsyncPurchaseOrdersClient  # noqa: E402

            self._purchase_orders = AsyncPurchaseOrdersClient(client_wrapper=self._client_wrapper)
        return self._purchase_orders

    @property
    def regenerate_key(self):
        if self._regenerate_key is None:
            from .resources.regenerate_key.client import AsyncRegenerateKeyClient  # noqa: E402

            self._regenerate_key = AsyncRegenerateKeyClient(client_wrapper=self._client_wrapper)
        return self._regenerate_key

    @property
    def sync_status(self):
        if self._sync_status is None:
            from .resources.sync_status.client import AsyncSyncStatusClient  # noqa: E402

            self._sync_status = AsyncSyncStatusClient(client_wrapper=self._client_wrapper)
        return self._sync_status

    @property
    def force_resync(self):
        if self._force_resync is None:
            from .resources.force_resync.client import AsyncForceResyncClient  # noqa: E402

            self._force_resync = AsyncForceResyncClient(client_wrapper=self._client_wrapper)
        return self._force_resync

    @property
    def tax_rates(self):
        if self._tax_rates is None:
            from .resources.tax_rates.client import AsyncTaxRatesClient  # noqa: E402

            self._tax_rates = AsyncTaxRatesClient(client_wrapper=self._client_wrapper)
        return self._tax_rates

    @property
    def tracking_categories(self):
        if self._tracking_categories is None:
            from .resources.tracking_categories.client import AsyncTrackingCategoriesClient  # noqa: E402

            self._tracking_categories = AsyncTrackingCategoriesClient(client_wrapper=self._client_wrapper)
        return self._tracking_categories

    @property
    def transactions(self):
        if self._transactions is None:
            from .resources.transactions.client import AsyncTransactionsClient  # noqa: E402

            self._transactions = AsyncTransactionsClient(client_wrapper=self._client_wrapper)
        return self._transactions

    @property
    def vendor_credits(self):
        if self._vendor_credits is None:
            from .resources.vendor_credits.client import AsyncVendorCreditsClient  # noqa: E402

            self._vendor_credits = AsyncVendorCreditsClient(client_wrapper=self._client_wrapper)
        return self._vendor_credits

    @property
    def webhook_receivers(self):
        if self._webhook_receivers is None:
            from .resources.webhook_receivers.client import AsyncWebhookReceiversClient  # noqa: E402

            self._webhook_receivers = AsyncWebhookReceiversClient(client_wrapper=self._client_wrapper)
        return self._webhook_receivers
