# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.async_post_task import AsyncPostTask
from .raw_client import AsyncRawAsyncTasksClient, RawAsyncTasksClient


class AsyncTasksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAsyncTasksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAsyncTasksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAsyncTasksClient
        """
        return self._raw_client

    def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AsyncPostTask:
        """
        Returns an `AsyncPostTask` object with the given `id`.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPostTask


        Examples
        --------
        from merge import Merge

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.accounting.async_tasks.retrieve(
            id="id",
        )
        """
        _response = self._raw_client.retrieve(id, request_options=request_options)
        return _response.data


class AsyncAsyncTasksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAsyncTasksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAsyncTasksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAsyncTasksClient
        """
        return self._raw_client

    async def retrieve(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AsyncPostTask:
        """
        Returns an `AsyncPostTask` object with the given `id`.

        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPostTask


        Examples
        --------
        import asyncio

        from merge import AsyncMerge

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.accounting.async_tasks.retrieve(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(id, request_options=request_options)
        return _response.data
