# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ...types.general_ledger_transaction import GeneralLedgerTransaction
from ...types.paginated_general_ledger_transaction_list import PaginatedGeneralLedgerTransactionList
from .raw_client import AsyncRawGeneralLedgerTransactionsClient, RawGeneralLedgerTransactionsClient
from .types.general_ledger_transactions_list_request_expand import GeneralLedgerTransactionsListRequestExpand
from .types.general_ledger_transactions_retrieve_request_expand import GeneralLedgerTransactionsRetrieveRequestExpand


class GeneralLedgerTransactionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawGeneralLedgerTransactionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawGeneralLedgerTransactionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawGeneralLedgerTransactionsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        company_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[GeneralLedgerTransactionsListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        posted_date_after: typing.Optional[dt.datetime] = None,
        posted_date_before: typing.Optional[dt.datetime] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedGeneralLedgerTransactionList:
        """
        Returns a list of `GeneralLedgerTransaction` objects.

        Parameters
        ----------
        company_id : typing.Optional[str]
            If provided, will only return general ledger transactions for this company.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[GeneralLedgerTransactionsListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page.

        posted_date_after : typing.Optional[dt.datetime]
            If provided, will only return objects posted after this datetime.

        posted_date_before : typing.Optional[dt.datetime]
            If provided, will only return objects posted before this datetime.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedGeneralLedgerTransactionList


        Examples
        --------
        import datetime

        from merge import Merge
        from merge.resources.accounting.resources.general_ledger_transactions import (
            GeneralLedgerTransactionsListRequestExpand,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.accounting.general_ledger_transactions.list(
            company_id="company_id",
            created_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            created_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
            expand=GeneralLedgerTransactionsListRequestExpand.ACCOUNTING_PERIOD,
            include_deleted_data=True,
            include_remote_data=True,
            include_shell_data=True,
            modified_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            modified_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            page_size=1,
            posted_date_after=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            posted_date_before=datetime.datetime.fromisoformat(
                "2024-01-15 09:30:00+00:00",
            ),
            remote_id="remote_id",
        )
        """
        _response = self._raw_client.list(
            company_id=company_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            posted_date_after=posted_date_after,
            posted_date_before=posted_date_before,
            remote_id=remote_id,
            request_options=request_options,
        )
        return _response.data

    def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[GeneralLedgerTransactionsRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GeneralLedgerTransaction:
        """
        Returns a `GeneralLedgerTransaction` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[GeneralLedgerTransactionsRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GeneralLedgerTransaction


        Examples
        --------
        from merge import Merge
        from merge.resources.accounting.resources.general_ledger_transactions import (
            GeneralLedgerTransactionsRetrieveRequestExpand,
        )

        client = Merge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )
        client.accounting.general_ledger_transactions.retrieve(
            id="id",
            expand=GeneralLedgerTransactionsRetrieveRequestExpand.ACCOUNTING_PERIOD,
            include_remote_data=True,
            include_shell_data=True,
        )
        """
        _response = self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data


class AsyncGeneralLedgerTransactionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawGeneralLedgerTransactionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawGeneralLedgerTransactionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawGeneralLedgerTransactionsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        company_id: typing.Optional[str] = None,
        created_after: typing.Optional[dt.datetime] = None,
        created_before: typing.Optional[dt.datetime] = None,
        cursor: typing.Optional[str] = None,
        expand: typing.Optional[GeneralLedgerTransactionsListRequestExpand] = None,
        include_deleted_data: typing.Optional[bool] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        modified_after: typing.Optional[dt.datetime] = None,
        modified_before: typing.Optional[dt.datetime] = None,
        page_size: typing.Optional[int] = None,
        posted_date_after: typing.Optional[dt.datetime] = None,
        posted_date_before: typing.Optional[dt.datetime] = None,
        remote_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedGeneralLedgerTransactionList:
        """
        Returns a list of `GeneralLedgerTransaction` objects.

        Parameters
        ----------
        company_id : typing.Optional[str]
            If provided, will only return general ledger transactions for this company.

        created_after : typing.Optional[dt.datetime]
            If provided, will only return objects created after this datetime.

        created_before : typing.Optional[dt.datetime]
            If provided, will only return objects created before this datetime.

        cursor : typing.Optional[str]
            The pagination cursor value.

        expand : typing.Optional[GeneralLedgerTransactionsListRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_deleted_data : typing.Optional[bool]
            Indicates whether or not this object has been deleted in the third party platform. Full coverage deletion detection is a premium add-on. Native deletion detection is offered for free with limited coverage. [Learn more](https://docs.merge.dev/integrations/hris/supported-features/).

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        modified_after : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge after this date time will be returned.

        modified_before : typing.Optional[dt.datetime]
            If provided, only objects synced by Merge before this date time will be returned.

        page_size : typing.Optional[int]
            Number of results to return per page.

        posted_date_after : typing.Optional[dt.datetime]
            If provided, will only return objects posted after this datetime.

        posted_date_before : typing.Optional[dt.datetime]
            If provided, will only return objects posted before this datetime.

        remote_id : typing.Optional[str]
            The API provider's ID for the given object.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedGeneralLedgerTransactionList


        Examples
        --------
        import asyncio
        import datetime

        from merge import AsyncMerge
        from merge.resources.accounting.resources.general_ledger_transactions import (
            GeneralLedgerTransactionsListRequestExpand,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.accounting.general_ledger_transactions.list(
                company_id="company_id",
                created_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                created_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                cursor="cD0yMDIxLTAxLTA2KzAzJTNBMjQlM0E1My40MzQzMjYlMkIwMCUzQTAw",
                expand=GeneralLedgerTransactionsListRequestExpand.ACCOUNTING_PERIOD,
                include_deleted_data=True,
                include_remote_data=True,
                include_shell_data=True,
                modified_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                modified_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                page_size=1,
                posted_date_after=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                posted_date_before=datetime.datetime.fromisoformat(
                    "2024-01-15 09:30:00+00:00",
                ),
                remote_id="remote_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            company_id=company_id,
            created_after=created_after,
            created_before=created_before,
            cursor=cursor,
            expand=expand,
            include_deleted_data=include_deleted_data,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            modified_after=modified_after,
            modified_before=modified_before,
            page_size=page_size,
            posted_date_after=posted_date_after,
            posted_date_before=posted_date_before,
            remote_id=remote_id,
            request_options=request_options,
        )
        return _response.data

    async def retrieve(
        self,
        id: str,
        *,
        expand: typing.Optional[GeneralLedgerTransactionsRetrieveRequestExpand] = None,
        include_remote_data: typing.Optional[bool] = None,
        include_shell_data: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GeneralLedgerTransaction:
        """
        Returns a `GeneralLedgerTransaction` object with the given `id`.

        Parameters
        ----------
        id : str

        expand : typing.Optional[GeneralLedgerTransactionsRetrieveRequestExpand]
            Which relations should be returned in expanded form. Multiple relation names should be comma separated without spaces.

        include_remote_data : typing.Optional[bool]
            Whether to include the original data Merge fetched from the third-party to produce these models.

        include_shell_data : typing.Optional[bool]
            Whether to include shell records. Shell records are empty records (they may contain some metadata but all other fields are null).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GeneralLedgerTransaction


        Examples
        --------
        import asyncio

        from merge import AsyncMerge
        from merge.resources.accounting.resources.general_ledger_transactions import (
            GeneralLedgerTransactionsRetrieveRequestExpand,
        )

        client = AsyncMerge(
            account_token="YOUR_ACCOUNT_TOKEN",
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.accounting.general_ledger_transactions.retrieve(
                id="id",
                expand=GeneralLedgerTransactionsRetrieveRequestExpand.ACCOUNTING_PERIOD,
                include_remote_data=True,
                include_shell_data=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve(
            id,
            expand=expand,
            include_remote_data=include_remote_data,
            include_shell_data=include_shell_data,
            request_options=request_options,
        )
        return _response.data
